@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.ServiceArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.enums.Kind
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServicesPropertiesArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServicesPropertiesArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServicesResourceIdentityArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServicesResourceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of the service.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2020-03-15, 2023-09-06, 2023-11-01, 2023-12-01, 2024-03-01, 2024-03-31.
 * ## Example Usage
 * ### Create or Update a service with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.HealthcareApis.Service("service", new()
 *     {
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServicesResourceIdentityArgs
 *         {
 *             Type = AzureNative.HealthcareApis.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.HealthcareApis.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.HealthcareApis.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *                 },
 *             },
 *             AuthenticationConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceAuthenticationConfigurationInfoArgs
 *             {
 *                 Audience = "https://azurehealthcareapis.com",
 *                 Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *                 SmartProxyEnabled = true,
 *             },
 *             CorsConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCorsConfigurationInfoArgs
 *             {
 *                 AllowCredentials = false,
 *                 Headers = new[]
 *                 {
 *                     "*",
 *                 },
 *                 MaxAge = 1440,
 *                 Methods = new[]
 *                 {
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT",
 *                 },
 *                 Origins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             CosmosDbConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCosmosDbConfigurationInfoArgs
 *             {
 *                 KeyVaultKeyUri = "https://my-vault.vault.azure.net/keys/my-key",
 *                 OfferThroughput = 1000,
 *             },
 *             ExportConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceExportConfigurationInfoArgs
 *             {
 *                 StorageAccountName = "existingStorageAccount",
 *             },
 *             PrivateEndpointConnections = new() { },
 *             PublicNetworkAccess = AzureNative.HealthcareApis.PublicNetworkAccess.Disabled,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewService(ctx, "service", &healthcareapis.ServiceArgs{
 * 			Identity: &healthcareapis.ServicesResourceIdentityArgs{
 * 				Type: pulumi.String(healthcareapis.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Kind:     healthcareapis.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &healthcareapis.ServicesPropertiesArgs{
 * 				AccessPolicies: healthcareapis.ServiceAccessPolicyEntryArray{
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 					},
 * 				},
 * 				AuthenticationConfiguration: &healthcareapis.ServiceAuthenticationConfigurationInfoArgs{
 * 					Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 					Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 					SmartProxyEnabled: pulumi.Bool(true),
 * 				},
 * 				CorsConfiguration: &healthcareapis.ServiceCorsConfigurationInfoArgs{
 * 					AllowCredentials: pulumi.Bool(false),
 * 					Headers: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					MaxAge: pulumi.Int(1440),
 * 					Methods: pulumi.StringArray{
 * 						pulumi.String("DELETE"),
 * 						pulumi.String("GET"),
 * 						pulumi.String("OPTIONS"),
 * 						pulumi.String("PATCH"),
 * 						pulumi.String("POST"),
 * 						pulumi.String("PUT"),
 * 					},
 * 					Origins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				CosmosDbConfiguration: &healthcareapis.ServiceCosmosDbConfigurationInfoArgs{
 * 					KeyVaultKeyUri:  pulumi.String("https://my-vault.vault.azure.net/keys/my-key"),
 * 					OfferThroughput: pulumi.Int(1000),
 * 				},
 * 				ExportConfiguration: &healthcareapis.ServiceExportConfigurationInfoArgs{
 * 					StorageAccountName: pulumi.String("existingStorageAccount"),
 * 				},
 * 				PrivateEndpointConnections: healthcareapis.PrivateEndpointConnectionTypeArray{},
 * 				PublicNetworkAccess:        pulumi.String(healthcareapis.PublicNetworkAccessDisabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.Service;
 * import com.pulumi.azurenative.healthcareapis.ServiceArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesPropertiesArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceAuthenticationConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCorsConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .identity(ServicesResourceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                         .build(),
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("5b307da8-43d4-492b-8b66-b0294ade872f")
 *                         .build())
 *                 .authenticationConfiguration(ServiceAuthenticationConfigurationInfoArgs.builder()
 *                     .audience("https://azurehealthcareapis.com")
 *                     .authority("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc")
 *                     .smartProxyEnabled(true)
 *                     .build())
 *                 .corsConfiguration(ServiceCorsConfigurationInfoArgs.builder()
 *                     .allowCredentials(false)
 *                     .headers("*")
 *                     .maxAge(1440)
 *                     .methods(
 *                         "DELETE",
 *                         "GET",
 *                         "OPTIONS",
 *                         "PATCH",
 *                         "POST",
 *                         "PUT")
 *                     .origins("*")
 *                     .build())
 *                 .cosmosDbConfiguration(ServiceCosmosDbConfigurationInfoArgs.builder()
 *                     .keyVaultKeyUri("https://my-vault.vault.azure.net/keys/my-key")
 *                     .offerThroughput(1000)
 *                     .build())
 *                 .exportConfiguration(ServiceExportConfigurationInfoArgs.builder()
 *                     .storageAccountName("existingStorageAccount")
 *                     .build())
 *                 .privateEndpointConnections()
 *                 .publicNetworkAccess("Disabled")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a service with all parameters and CMK enabled in a data sovereign region
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.HealthcareApis.Service("service", new()
 *     {
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServicesResourceIdentityArgs
 *         {
 *             Type = AzureNative.HealthcareApis.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.HealthcareApis.Kind.Fhir_R4,
 *         Location = "Southeast Asia",
 *         Properties = new AzureNative.HealthcareApis.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "5b307da8-43d4-492b-8b66-b0294ade872f",
 *                 },
 *             },
 *             AuthenticationConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceAuthenticationConfigurationInfoArgs
 *             {
 *                 Audience = "https://azurehealthcareapis.com",
 *                 Authority = "https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc",
 *                 SmartProxyEnabled = true,
 *             },
 *             CorsConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCorsConfigurationInfoArgs
 *             {
 *                 AllowCredentials = false,
 *                 Headers = new[]
 *                 {
 *                     "*",
 *                 },
 *                 MaxAge = 1440,
 *                 Methods = new[]
 *                 {
 *                     "DELETE",
 *                     "GET",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT",
 *                 },
 *                 Origins = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             CosmosDbConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceCosmosDbConfigurationInfoArgs
 *             {
 *                 CrossTenantCmkApplicationId = "de3fbeef-8c3a-428e-8b9f-4d229c8a85f4",
 *                 KeyVaultKeyUri = "https://my-vault.vault.azure.net/keys/my-key",
 *                 OfferThroughput = 1000,
 *             },
 *             ExportConfiguration = new AzureNative.HealthcareApis.Inputs.ServiceExportConfigurationInfoArgs
 *             {
 *                 StorageAccountName = "existingStorageAccount",
 *             },
 *             PrivateEndpointConnections = new() { },
 *             PublicNetworkAccess = AzureNative.HealthcareApis.PublicNetworkAccess.Disabled,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewService(ctx, "service", &healthcareapis.ServiceArgs{
 * 			Identity: &healthcareapis.ServicesResourceIdentityArgs{
 * 				Type: pulumi.String(healthcareapis.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Kind:     healthcareapis.Kind_Fhir_R4,
 * 			Location: pulumi.String("Southeast Asia"),
 * 			Properties: &healthcareapis.ServicesPropertiesArgs{
 * 				AccessPolicies: healthcareapis.ServiceAccessPolicyEntryArray{
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("5b307da8-43d4-492b-8b66-b0294ade872f"),
 * 					},
 * 				},
 * 				AuthenticationConfiguration: &healthcareapis.ServiceAuthenticationConfigurationInfoArgs{
 * 					Audience:          pulumi.String("https://azurehealthcareapis.com"),
 * 					Authority:         pulumi.String("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc"),
 * 					SmartProxyEnabled: pulumi.Bool(true),
 * 				},
 * 				CorsConfiguration: &healthcareapis.ServiceCorsConfigurationInfoArgs{
 * 					AllowCredentials: pulumi.Bool(false),
 * 					Headers: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					MaxAge: pulumi.Int(1440),
 * 					Methods: pulumi.StringArray{
 * 						pulumi.String("DELETE"),
 * 						pulumi.String("GET"),
 * 						pulumi.String("OPTIONS"),
 * 						pulumi.String("PATCH"),
 * 						pulumi.String("POST"),
 * 						pulumi.String("PUT"),
 * 					},
 * 					Origins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				CosmosDbConfiguration: &healthcareapis.ServiceCosmosDbConfigurationInfoArgs{
 * 					CrossTenantCmkApplicationId: pulumi.String("de3fbeef-8c3a-428e-8b9f-4d229c8a85f4"),
 * 					KeyVaultKeyUri:              pulumi.String("https://my-vault.vault.azure.net/keys/my-key"),
 * 					OfferThroughput:             pulumi.Int(1000),
 * 				},
 * 				ExportConfiguration: &healthcareapis.ServiceExportConfigurationInfoArgs{
 * 					StorageAccountName: pulumi.String("existingStorageAccount"),
 * 				},
 * 				PrivateEndpointConnections: healthcareapis.PrivateEndpointConnectionTypeArray{},
 * 				PublicNetworkAccess:        pulumi.String(healthcareapis.PublicNetworkAccessDisabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.Service;
 * import com.pulumi.azurenative.healthcareapis.ServiceArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesResourceIdentityArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesPropertiesArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceAuthenticationConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCorsConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceCosmosDbConfigurationInfoArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServiceExportConfigurationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .identity(ServicesResourceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("fhir-R4")
 *             .location("Southeast Asia")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                         .build(),
 *                     ServiceAccessPolicyEntryArgs.builder()
 *                         .objectId("5b307da8-43d4-492b-8b66-b0294ade872f")
 *                         .build())
 *                 .authenticationConfiguration(ServiceAuthenticationConfigurationInfoArgs.builder()
 *                     .audience("https://azurehealthcareapis.com")
 *                     .authority("https://login.microsoftonline.com/abfde7b2-df0f-47e6-aabf-2462b07508dc")
 *                     .smartProxyEnabled(true)
 *                     .build())
 *                 .corsConfiguration(ServiceCorsConfigurationInfoArgs.builder()
 *                     .allowCredentials(false)
 *                     .headers("*")
 *                     .maxAge(1440)
 *                     .methods(
 *                         "DELETE",
 *                         "GET",
 *                         "OPTIONS",
 *                         "PATCH",
 *                         "POST",
 *                         "PUT")
 *                     .origins("*")
 *                     .build())
 *                 .cosmosDbConfiguration(ServiceCosmosDbConfigurationInfoArgs.builder()
 *                     .crossTenantCmkApplicationId("de3fbeef-8c3a-428e-8b9f-4d229c8a85f4")
 *                     .keyVaultKeyUri("https://my-vault.vault.azure.net/keys/my-key")
 *                     .offerThroughput(1000)
 *                     .build())
 *                 .exportConfiguration(ServiceExportConfigurationInfoArgs.builder()
 *                     .storageAccountName("existingStorageAccount")
 *                     .build())
 *                 .privateEndpointConnections()
 *                 .publicNetworkAccess("Disabled")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a service with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.HealthcareApis.Service("service", new()
 *     {
 *         Kind = AzureNative.HealthcareApis.Kind.Fhir_R4,
 *         Location = "westus2",
 *         Properties = new AzureNative.HealthcareApis.Inputs.ServicesPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.HealthcareApis.Inputs.ServiceAccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "c487e7d1-3210-41a3-8ccc-e9372b78da47",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "service2",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewService(ctx, "service", &healthcareapis.ServiceArgs{
 * 			Kind:     healthcareapis.Kind_Fhir_R4,
 * 			Location: pulumi.String("westus2"),
 * 			Properties: &healthcareapis.ServicesPropertiesArgs{
 * 				AccessPolicies: healthcareapis.ServiceAccessPolicyEntryArray{
 * 					&healthcareapis.ServiceAccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("c487e7d1-3210-41a3-8ccc-e9372b78da47"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("service2"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.Service;
 * import com.pulumi.azurenative.healthcareapis.ServiceArgs;
 * import com.pulumi.azurenative.healthcareapis.inputs.ServicesPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .kind("fhir-R4")
 *             .location("westus2")
 *             .properties(ServicesPropertiesArgs.builder()
 *                 .accessPolicies(ServiceAccessPolicyEntryArgs.builder()
 *                     .objectId("c487e7d1-3210-41a3-8ccc-e9372b78da47")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("service2")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:Service service2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/services/{resourceName}
 * ```
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property kind The kind of the service.
 * @property location The resource location.
 * @property properties The common properties of a service.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 * @property tags The resource tags.
 */
public data class ServiceArgs(
    public val identity: Output<ServicesResourceIdentityArgs>? = null,
    public val kind: Output<Kind>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ServicesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.ServiceArgs =
        com.pulumi.azurenative.healthcareapis.ServiceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var identity: Output<ServicesResourceIdentityArgs>? = null

    private var kind: Output<Kind>? = null

    private var location: Output<String>? = null

    private var properties: Output<ServicesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("hajdtjibecjxxfko")
    public suspend fun identity(`value`: Output<ServicesResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("xabpfumdkvnmorig")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("epdsxbmalaeorgnh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The common properties of a service.
     */
    @JvmName("jvpmjrviexnlgyeg")
    public suspend fun properties(`value`: Output<ServicesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("vsxyqbyfimipdkut")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("cuidifgsaogsxyuu")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("pwrahawxewigkecq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("kmikhpjfjfuqjwfu")
    public suspend fun identity(`value`: ServicesResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("faixwoeplutbtamu")
    public suspend fun identity(argument: suspend ServicesResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ServicesResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of the service.
     */
    @JvmName("bytpjuxbaqerjkoo")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("pvumrcgbxchdiosr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The common properties of a service.
     */
    @JvmName("xeqbqxogqebuautg")
    public suspend fun properties(`value`: ServicesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The common properties of a service.
     */
    @JvmName("oimbakrtfwsmxlys")
    public suspend fun properties(argument: suspend ServicesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServicesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("avagimaussyruaem")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("leqgkcppahwwxkso")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("vskuguuuoekqqtya")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("ynbpdmpyaigcostd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        identity = identity,
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
