@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of identity being specified, currently SystemAssigned and None are allowed.
 */
public enum class ServiceManagedIdentityType(
    public val javaValue: com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType> {
    None(com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.enums.ServiceManagedIdentityType):
            ServiceManagedIdentityType =
            ServiceManagedIdentityType.values().first { it.javaValue == javaType }
    }
}
