@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirToParquetMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * FHIR Service data mapping configuration for Analytics Connector.
 * @property extensionSchemaReference Artifact reference for extension schema.
 * @property filterConfigurationReference Artifact reference for filter configurations.
 * @property type Type of data mapping.
 * Expected value is 'fhirToParquet'.
 */
public data class AnalyticsConnectorFhirToParquetMappingArgs(
    public val extensionSchemaReference: Output<String>? = null,
    public val filterConfigurationReference: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirToParquetMappingArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirToParquetMappingArgs =
        com.pulumi.azurenative.healthcareapis.inputs.AnalyticsConnectorFhirToParquetMappingArgs.builder()
            .extensionSchemaReference(extensionSchemaReference?.applyValue({ args0 -> args0 }))
            .filterConfigurationReference(filterConfigurationReference?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsConnectorFhirToParquetMappingArgs].
 */
@PulumiTagMarker
public class AnalyticsConnectorFhirToParquetMappingArgsBuilder internal constructor() {
    private var extensionSchemaReference: Output<String>? = null

    private var filterConfigurationReference: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Artifact reference for extension schema.
     */
    @JvmName("qbpldbpxofveuxvj")
    public suspend fun extensionSchemaReference(`value`: Output<String>) {
        this.extensionSchemaReference = value
    }

    /**
     * @param value Artifact reference for filter configurations.
     */
    @JvmName("uulbsomoooyltbmo")
    public suspend fun filterConfigurationReference(`value`: Output<String>) {
        this.filterConfigurationReference = value
    }

    /**
     * @param value Type of data mapping.
     * Expected value is 'fhirToParquet'.
     */
    @JvmName("umaadewaktnjjlvh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Artifact reference for extension schema.
     */
    @JvmName("mgewgatjuxgxdecv")
    public suspend fun extensionSchemaReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionSchemaReference = mapped
    }

    /**
     * @param value Artifact reference for filter configurations.
     */
    @JvmName("cuospdxxcayluoad")
    public suspend fun filterConfigurationReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterConfigurationReference = mapped
    }

    /**
     * @param value Type of data mapping.
     * Expected value is 'fhirToParquet'.
     */
    @JvmName("jmaywkbvgjoaxmri")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AnalyticsConnectorFhirToParquetMappingArgs =
        AnalyticsConnectorFhirToParquetMappingArgs(
            extensionSchemaReference = extensionSchemaReference,
            filterConfigurationReference = filterConfigurationReference,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
