@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ImplementationGuidesConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings for Implementation Guides - defining capabilities for national standards, vendor consortiums, clinical societies, etc.
 * @property usCoreMissingData If US Core Missing Data requirement is enabled.
 */
public data class ImplementationGuidesConfigurationArgs(
    public val usCoreMissingData: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ImplementationGuidesConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.ImplementationGuidesConfigurationArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ImplementationGuidesConfigurationArgs.builder()
            .usCoreMissingData(usCoreMissingData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImplementationGuidesConfigurationArgs].
 */
@PulumiTagMarker
public class ImplementationGuidesConfigurationArgsBuilder internal constructor() {
    private var usCoreMissingData: Output<Boolean>? = null

    /**
     * @param value If US Core Missing Data requirement is enabled.
     */
    @JvmName("mvlrcilcjfvfwaye")
    public suspend fun usCoreMissingData(`value`: Output<Boolean>) {
        this.usCoreMissingData = value
    }

    /**
     * @param value If US Core Missing Data requirement is enabled.
     */
    @JvmName("igpdedlrticoogvk")
    public suspend fun usCoreMissingData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usCoreMissingData = mapped
    }

    internal fun build(): ImplementationGuidesConfigurationArgs =
        ImplementationGuidesConfigurationArgs(
            usCoreMissingData = usCoreMissingData,
        )
}
