@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ServiceAcrConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure container registry configuration information
 * @property loginServers The list of the ACR login servers.
 * @property ociArtifacts The list of Open Container Initiative (OCI) artifacts.
 */
public data class ServiceAcrConfigurationInfoArgs(
    public val loginServers: Output<List<String>>? = null,
    public val ociArtifacts: Output<List<ServiceOciArtifactEntryArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ServiceAcrConfigurationInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.ServiceAcrConfigurationInfoArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ServiceAcrConfigurationInfoArgs.builder()
            .loginServers(loginServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ociArtifacts(
                ociArtifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceAcrConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ServiceAcrConfigurationInfoArgsBuilder internal constructor() {
    private var loginServers: Output<List<String>>? = null

    private var ociArtifacts: Output<List<ServiceOciArtifactEntryArgs>>? = null

    /**
     * @param value The list of the ACR login servers.
     */
    @JvmName("bgbwyfcafdyeejgk")
    public suspend fun loginServers(`value`: Output<List<String>>) {
        this.loginServers = value
    }

    @JvmName("dpsjumcaekssjfpx")
    public suspend fun loginServers(vararg values: Output<String>) {
        this.loginServers = Output.all(values.asList())
    }

    /**
     * @param values The list of the ACR login servers.
     */
    @JvmName("tpaaiemjtvgiwebc")
    public suspend fun loginServers(values: List<Output<String>>) {
        this.loginServers = Output.all(values)
    }

    /**
     * @param value The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("bchxuuwqbvxhsfjd")
    public suspend fun ociArtifacts(`value`: Output<List<ServiceOciArtifactEntryArgs>>) {
        this.ociArtifacts = value
    }

    @JvmName("xbfpovpambqmwgtc")
    public suspend fun ociArtifacts(vararg values: Output<ServiceOciArtifactEntryArgs>) {
        this.ociArtifacts = Output.all(values.asList())
    }

    /**
     * @param values The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("ewwtwvmodvhbhxum")
    public suspend fun ociArtifacts(values: List<Output<ServiceOciArtifactEntryArgs>>) {
        this.ociArtifacts = Output.all(values)
    }

    /**
     * @param value The list of the ACR login servers.
     */
    @JvmName("xeibjkjmlbxvyvxi")
    public suspend fun loginServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginServers = mapped
    }

    /**
     * @param values The list of the ACR login servers.
     */
    @JvmName("idckdtfceckydbfs")
    public suspend fun loginServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loginServers = mapped
    }

    /**
     * @param value The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("takyuqnlfrimpacg")
    public suspend fun ociArtifacts(`value`: List<ServiceOciArtifactEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ociArtifacts = mapped
    }

    /**
     * @param argument The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("ompwjffudmxogsml")
    public suspend
    fun ociArtifacts(argument: List<suspend ServiceOciArtifactEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceOciArtifactEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ociArtifacts = mapped
    }

    /**
     * @param argument The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("vxqyjrqulffvxeaa")
    public suspend fun ociArtifacts(
        vararg
        argument: suspend ServiceOciArtifactEntryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceOciArtifactEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ociArtifacts = mapped
    }

    /**
     * @param argument The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("hlrcjnomjtsxxiku")
    public suspend fun ociArtifacts(argument: suspend ServiceOciArtifactEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceOciArtifactEntryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ociArtifacts = mapped
    }

    /**
     * @param values The list of Open Container Initiative (OCI) artifacts.
     */
    @JvmName("kqkgujvayemdvjua")
    public suspend fun ociArtifacts(vararg values: ServiceOciArtifactEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ociArtifacts = mapped
    }

    internal fun build(): ServiceAcrConfigurationInfoArgs = ServiceAcrConfigurationInfoArgs(
        loginServers = loginServers,
        ociArtifacts = ociArtifacts,
    )
}
