@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ServiceManagedIdentityIdentityArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.enums.ServiceManagedIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Setting indicating whether the service has a managed identity associated with it.
 * @property type Type of identity being specified, currently SystemAssigned and None are allowed.
 * @property userAssignedIdentities The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
 */
public data class ServiceManagedIdentityIdentityArgs(
    public val type: Output<Either<String, ServiceManagedIdentityType>>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ServiceManagedIdentityIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.ServiceManagedIdentityIdentityArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ServiceManagedIdentityIdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceManagedIdentityIdentityArgs].
 */
@PulumiTagMarker
public class ServiceManagedIdentityIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ServiceManagedIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("eifvutqodwycpptb")
    public suspend fun type(`value`: Output<Either<String, ServiceManagedIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("jlsknvarkwypeeet")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("lmlvqkualsjdfpwy")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("sdjafwxeflsfmamr")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("pgmccgmjinonapjj")
    public suspend fun type(`value`: Either<String, ServiceManagedIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("tekvccapifhpxpcc")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of identity being specified, currently SystemAssigned and None are allowed.
     */
    @JvmName("fpbbhvbfqsjwjpqi")
    public fun type(`value`: ServiceManagedIdentityType) {
        val toBeMapped = Either.ofRight<String, ServiceManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("yshgwgdkbhslxvqf")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("xebbevdegpeadnfj")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ServiceManagedIdentityIdentityArgs = ServiceManagedIdentityIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
