@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.ServiceOciArtifactEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Open Container Initiative (OCI) artifact.
 * @property digest The artifact digest.
 * @property imageName The artifact name.
 * @property loginServer The Azure Container Registry login server.
 */
public data class ServiceOciArtifactEntryArgs(
    public val digest: Output<String>? = null,
    public val imageName: Output<String>? = null,
    public val loginServer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.ServiceOciArtifactEntryArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.ServiceOciArtifactEntryArgs =
        com.pulumi.azurenative.healthcareapis.inputs.ServiceOciArtifactEntryArgs.builder()
            .digest(digest?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .loginServer(loginServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceOciArtifactEntryArgs].
 */
@PulumiTagMarker
public class ServiceOciArtifactEntryArgsBuilder internal constructor() {
    private var digest: Output<String>? = null

    private var imageName: Output<String>? = null

    private var loginServer: Output<String>? = null

    /**
     * @param value The artifact digest.
     */
    @JvmName("khklmfnukmifuoba")
    public suspend fun digest(`value`: Output<String>) {
        this.digest = value
    }

    /**
     * @param value The artifact name.
     */
    @JvmName("vfolaqttqdyndvlg")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The Azure Container Registry login server.
     */
    @JvmName("baelcvdplicnijfk")
    public suspend fun loginServer(`value`: Output<String>) {
        this.loginServer = value
    }

    /**
     * @param value The artifact digest.
     */
    @JvmName("wpbupivrseqaqnql")
    public suspend fun digest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.digest = mapped
    }

    /**
     * @param value The artifact name.
     */
    @JvmName("oaifcocsbncrkrbk")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value The Azure Container Registry login server.
     */
    @JvmName("rbykewoyocaygyjo")
    public suspend fun loginServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginServer = mapped
    }

    internal fun build(): ServiceOciArtifactEntryArgs = ServiceOciArtifactEntryArgs(
        digest = digest,
        imageName = imageName,
        loginServer = loginServer,
    )
}
