@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The settings for the CORS configuration of the service instance.
 * @property allowCredentials If credentials are allowed via CORS.
 * @property headers The headers to be allowed via CORS.
 * @property maxAge The max age to be allowed via CORS.
 * @property methods The methods to be allowed via CORS.
 * @property origins The origins to be allowed via CORS.
 */
public data class CorsConfigurationResponse(
    public val allowCredentials: Boolean? = null,
    public val headers: List<String>? = null,
    public val maxAge: Int? = null,
    public val methods: List<String>? = null,
    public val origins: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.CorsConfigurationResponse):
            CorsConfigurationResponse = CorsConfigurationResponse(
            allowCredentials = javaType.allowCredentials().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0 }),
            maxAge = javaType.maxAge().map({ args0 -> args0 }).orElse(null),
            methods = javaType.methods().map({ args0 -> args0 }),
            origins = javaType.origins().map({ args0 -> args0 }),
        )
    }
}
