@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * IoT Connector definition.
 * @property deviceMapping Device Mappings.
 * @property etag An etag associated with the resource, used for optimistic concurrency when editing it.
 * @property id The resource identifier.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property ingestionEndpointConfiguration Source configuration.
 * @property location The resource location.
 * @property name The resource name.
 * @property provisioningState The provisioning state.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The resource type.
 */
public data class GetIotConnectorResult(
    public val deviceMapping: IotMappingPropertiesResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val identity: ServiceManagedIdentityResponseIdentity? = null,
    public val ingestionEndpointConfiguration: IotEventHubIngestionEndpointConfigurationResponse? =
        null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.GetIotConnectorResult):
            GetIotConnectorResult = GetIotConnectorResult(
            deviceMapping = javaType.deviceMapping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotMappingPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ingestionEndpointConfiguration = javaType.ingestionEndpointConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotEventHubIngestionEndpointConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
