@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Workspace resource.
 * @property etag An etag associated with the resource, used for optimistic concurrency when editing it.
 * @property id The resource identifier.
 * @property location The resource location.
 * @property name The resource name.
 * @property properties Workspaces resource specific properties.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The resource type.
 */
public data class GetWorkspaceResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: WorkspaceResponseProperties,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.GetWorkspaceResult):
            GetWorkspaceResult = GetWorkspaceResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.WorkspaceResponseProperties.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
