@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcloud.kotlin

import com.pulumi.azurenative.hybridcloud.CloudConnectionArgs.builder
import com.pulumi.azurenative.hybridcloud.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.hybridcloud.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource which represents the managed network connection between Azure Gateways and remote cloud gateways.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2023-01-01-preview.
 * ## Example Usage
 * ### Create a Cloud Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudConnection = new AzureNative.HybridCloud.CloudConnection("cloudConnection", new()
 *     {
 *         CloudConnectionName = "cloudconnection1",
 *         CloudConnector = new AzureNative.HybridCloud.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.HybridCloud/cloudConnectors/123456789012",
 *         },
 *         Location = "West US",
 *         RemoteResourceId = "arn:aws:ec2:us-east-1:123456789012:VPNGateway/vgw-043da592550819c8a",
 *         ResourceGroupName = "demo-rg",
 *         SharedKey = "password123",
 *         VirtualHub = new AzureNative.HybridCloud.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.Network/VirtualHubs/testHub",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcloud.NewCloudConnection(ctx, "cloudConnection", &hybridcloud.CloudConnectionArgs{
 * 			CloudConnectionName: pulumi.String("cloudconnection1"),
 * 			CloudConnector: &hybridcloud.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.HybridCloud/cloudConnectors/123456789012"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			RemoteResourceId:  pulumi.String("arn:aws:ec2:us-east-1:123456789012:VPNGateway/vgw-043da592550819c8a"),
 * 			ResourceGroupName: pulumi.String("demo-rg"),
 * 			SharedKey:         pulumi.String("password123"),
 * 			VirtualHub: &hybridcloud.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.Network/VirtualHubs/testHub"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcloud.CloudConnection;
 * import com.pulumi.azurenative.hybridcloud.CloudConnectionArgs;
 * import com.pulumi.azurenative.hybridcloud.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudConnection = new CloudConnection("cloudConnection", CloudConnectionArgs.builder()
 *             .cloudConnectionName("cloudconnection1")
 *             .cloudConnector(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.HybridCloud/cloudConnectors/123456789012")
 *                 .build())
 *             .location("West US")
 *             .remoteResourceId("arn:aws:ec2:us-east-1:123456789012:VPNGateway/vgw-043da592550819c8a")
 *             .resourceGroupName("demo-rg")
 *             .sharedKey("password123")
 *             .virtualHub(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/demo-rg/providers/Microsoft.Network/VirtualHubs/testHub")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcloud:CloudConnection cloudconnection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCloud/cloudConnections/{cloudConnectionName}
 * ```
 * @property cloudConnectionName The name of the cloud connection resource
 * @property cloudConnector The cloud connector which discovered the remote resource.
 * @property location The geo-location where the resource lives
 * @property remoteResourceId Identifier for the remote cloud resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sharedKey Shared key of the cloud connection.
 * @property tags Resource tags.
 * @property virtualHub The virtualHub to which the cloud connection belongs.
 */
public data class CloudConnectionArgs(
    public val cloudConnectionName: Output<String>? = null,
    public val cloudConnector: Output<ResourceReferenceArgs>? = null,
    public val location: Output<String>? = null,
    public val remoteResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sharedKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualHub: Output<ResourceReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcloud.CloudConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcloud.CloudConnectionArgs =
        com.pulumi.azurenative.hybridcloud.CloudConnectionArgs.builder()
            .cloudConnectionName(cloudConnectionName?.applyValue({ args0 -> args0 }))
            .cloudConnector(cloudConnector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .remoteResourceId(remoteResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualHub(virtualHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CloudConnectionArgs].
 */
@PulumiTagMarker
public class CloudConnectionArgsBuilder internal constructor() {
    private var cloudConnectionName: Output<String>? = null

    private var cloudConnector: Output<ResourceReferenceArgs>? = null

    private var location: Output<String>? = null

    private var remoteResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sharedKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualHub: Output<ResourceReferenceArgs>? = null

    /**
     * @param value The name of the cloud connection resource
     */
    @JvmName("safoltwperqfxmax")
    public suspend fun cloudConnectionName(`value`: Output<String>) {
        this.cloudConnectionName = value
    }

    /**
     * @param value The cloud connector which discovered the remote resource.
     */
    @JvmName("joyanvmgcgqrewii")
    public suspend fun cloudConnector(`value`: Output<ResourceReferenceArgs>) {
        this.cloudConnector = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mrdwywjcrwqyklub")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Identifier for the remote cloud resource
     */
    @JvmName("hooqvlniobayppxm")
    public suspend fun remoteResourceId(`value`: Output<String>) {
        this.remoteResourceId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("chbpihoyqixsjqwv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Shared key of the cloud connection.
     */
    @JvmName("ekeyoomdyiejboco")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fthqeyhqgplhfmgr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The virtualHub to which the cloud connection belongs.
     */
    @JvmName("hgqarlbxylhgfvvj")
    public suspend fun virtualHub(`value`: Output<ResourceReferenceArgs>) {
        this.virtualHub = value
    }

    /**
     * @param value The name of the cloud connection resource
     */
    @JvmName("wgphyldvnpwrbdra")
    public suspend fun cloudConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudConnectionName = mapped
    }

    /**
     * @param value The cloud connector which discovered the remote resource.
     */
    @JvmName("itcgkjxybxiyrgui")
    public suspend fun cloudConnector(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudConnector = mapped
    }

    /**
     * @param argument The cloud connector which discovered the remote resource.
     */
    @JvmName("fyhqxfraucihevdr")
    public suspend fun cloudConnector(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudConnector = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wdjywqlwgdmvpyue")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Identifier for the remote cloud resource
     */
    @JvmName("pgkxsxlthqmffdcc")
    public suspend fun remoteResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteResourceId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ugcfjxppcpyfgstf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Shared key of the cloud connection.
     */
    @JvmName("wfwkawxbfouxkhkk")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mqcccniecexslhep")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wkeuqwewneqirkrm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The virtualHub to which the cloud connection belongs.
     */
    @JvmName("oxprejwrovodkfbe")
    public suspend fun virtualHub(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHub = mapped
    }

    /**
     * @param argument The virtualHub to which the cloud connection belongs.
     */
    @JvmName("qgcwlseydmalfkrp")
    public suspend fun virtualHub(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualHub = mapped
    }

    internal fun build(): CloudConnectionArgs = CloudConnectionArgs(
        cloudConnectionName = cloudConnectionName,
        cloudConnector = cloudConnector,
        location = location,
        remoteResourceId = remoteResourceId,
        resourceGroupName = resourceGroupName,
        sharedKey = sharedKey,
        tags = tags,
        virtualHub = virtualHub,
    )
}
