@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcloud.kotlin

import com.pulumi.azurenative.hybridcloud.CloudConnectorArgs.builder
import com.pulumi.azurenative.hybridcloud.kotlin.enums.CloudType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cloud Connector resource.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2023-01-01-preview.
 * ## Example Usage
 * ### Create a Cloud Connector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudConnector = new AzureNative.HybridCloud.CloudConnector("cloudConnector", new()
 *     {
 *         AccountId = "123456789012",
 *         CloudConnectorName = "123456789012",
 *         CloudType = AzureNative.HybridCloud.CloudType.AWS,
 *         Location = "West US",
 *         ResourceGroupName = "demo-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcloud.NewCloudConnector(ctx, "cloudConnector", &hybridcloud.CloudConnectorArgs{
 * 			AccountId:          pulumi.String("123456789012"),
 * 			CloudConnectorName: pulumi.String("123456789012"),
 * 			CloudType:          pulumi.String(hybridcloud.CloudTypeAWS),
 * 			Location:           pulumi.String("West US"),
 * 			ResourceGroupName:  pulumi.String("demo-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcloud.CloudConnector;
 * import com.pulumi.azurenative.hybridcloud.CloudConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudConnector = new CloudConnector("cloudConnector", CloudConnectorArgs.builder()
 *             .accountId("123456789012")
 *             .cloudConnectorName("123456789012")
 *             .cloudType("AWS")
 *             .location("West US")
 *             .resourceGroupName("demo-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcloud:CloudConnector 123456789012 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCloud/cloudConnectors/{cloudConnectorName}
 * ```
 * @property accountId Account identifier of the remote cloud.
 * @property cloudConnectorName The name of the cloud connector resource
 * @property cloudType The cloud connector type.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class CloudConnectorArgs(
    public val accountId: Output<String>? = null,
    public val cloudConnectorName: Output<String>? = null,
    public val cloudType: Output<Either<String, CloudType>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcloud.CloudConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcloud.CloudConnectorArgs =
        com.pulumi.azurenative.hybridcloud.CloudConnectorArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .cloudConnectorName(cloudConnectorName?.applyValue({ args0 -> args0 }))
            .cloudType(
                cloudType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CloudConnectorArgs].
 */
@PulumiTagMarker
public class CloudConnectorArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var cloudConnectorName: Output<String>? = null

    private var cloudType: Output<Either<String, CloudType>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Account identifier of the remote cloud.
     */
    @JvmName("bnphexixmmyjgrpp")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The name of the cloud connector resource
     */
    @JvmName("iopamfkirfjuwfeb")
    public suspend fun cloudConnectorName(`value`: Output<String>) {
        this.cloudConnectorName = value
    }

    /**
     * @param value The cloud connector type.
     */
    @JvmName("ysihnusxtgonkfff")
    public suspend fun cloudType(`value`: Output<Either<String, CloudType>>) {
        this.cloudType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yftmbqhbhduswdmy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jacqjaobajwxlsba")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("epfyptgfsbalqjja")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Account identifier of the remote cloud.
     */
    @JvmName("lwhpybtokqvlfahw")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The name of the cloud connector resource
     */
    @JvmName("exxnijhrivaeijtv")
    public suspend fun cloudConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudConnectorName = mapped
    }

    /**
     * @param value The cloud connector type.
     */
    @JvmName("lmlmpglktkjvifeu")
    public suspend fun cloudType(`value`: Either<String, CloudType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudType = mapped
    }

    /**
     * @param value The cloud connector type.
     */
    @JvmName("lhxohstucugarmpb")
    public fun cloudType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudType = mapped
    }

    /**
     * @param value The cloud connector type.
     */
    @JvmName("xjgpvrcbieicwede")
    public fun cloudType(`value`: CloudType) {
        val toBeMapped = Either.ofRight<String, CloudType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jhltovbmscydqgdk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uamayktqcwgsmhwg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wfqmqksdakthsiod")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gcigjrhnfxcllxeb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CloudConnectorArgs = CloudConnectorArgs(
        accountId = accountId,
        cloudConnectorName = cloudConnectorName,
        cloudType = cloudType,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
