@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.kotlin.outputs.LicenseDetailsResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.LicenseDetailsResponse.Companion.toKotlin as licenseDetailsResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [License].
 */
@PulumiTagMarker
public class LicenseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LicenseArgs = LicenseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LicenseArgsBuilder.() -> Unit) {
        val builder = LicenseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): License {
        val builtJavaResource = com.pulumi.azurenative.hybridcompute.License(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return License(builtJavaResource)
    }
}

/**
 * Describes a license in a hybrid machine.
 * Azure REST API version: 2023-06-20-preview.
 * Other available API versions: 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a License
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var license = new AzureNative.HybridCompute.License("license", new()
 *     {
 *         LicenseDetails = new AzureNative.HybridCompute.Inputs.LicenseDetailsArgs
 *         {
 *             Edition = AzureNative.HybridCompute.LicenseEdition.Datacenter,
 *             Processors = 6,
 *             State = AzureNative.HybridCompute.LicenseState.Activated,
 *             Target = AzureNative.HybridCompute.LicenseTarget.Windows_Server_2012,
 *             Type = AzureNative.HybridCompute.LicenseCoreType.PCore,
 *         },
 *         LicenseName = "{licenseName}",
 *         LicenseType = AzureNative.HybridCompute.LicenseType.ESU,
 *         Location = "eastus2euap",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewLicense(ctx, "license", &hybridcompute.LicenseArgs{
 * 			LicenseDetails: &hybridcompute.LicenseDetailsArgs{
 * 				Edition:    pulumi.String(hybridcompute.LicenseEditionDatacenter),
 * 				Processors: pulumi.Int(6),
 * 				State:      pulumi.String(hybridcompute.LicenseStateActivated),
 * 				Target:     pulumi.String(hybridcompute.LicenseTarget_Windows_Server_2012),
 * 				Type:       pulumi.String(hybridcompute.LicenseCoreTypePCore),
 * 			},
 * 			LicenseName:       pulumi.String("{licenseName}"),
 * 			LicenseType:       pulumi.String(hybridcompute.LicenseTypeESU),
 * 			Location:          pulumi.String("eastus2euap"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.License;
 * import com.pulumi.azurenative.hybridcompute.LicenseArgs;
 * import com.pulumi.azurenative.hybridcompute.inputs.LicenseDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var license = new License("license", LicenseArgs.builder()
 *             .licenseDetails(LicenseDetailsArgs.builder()
 *                 .edition("Datacenter")
 *                 .processors(6)
 *                 .state("Activated")
 *                 .target("Windows Server 2012")
 *                 .type("pCore")
 *                 .build())
 *             .licenseName("{licenseName}")
 *             .licenseType("ESU")
 *             .location("eastus2euap")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:License {licenseName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}
 * ```
 */
public class License internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcompute.License,
) : KotlinCustomResource(javaResource, LicenseMapper) {
    /**
     * Describes the properties of a License.
     */
    public val licenseDetails: Output<LicenseDetailsResponse>?
        get() = javaResource.licenseDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> licenseDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of the license resource.
     */
    public val licenseType: Output<String>?
        get() = javaResource.licenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Describes the tenant id.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LicenseMapper : ResourceMapper<License> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcompute.License::class == javaResource::class

    override fun map(javaResource: Resource): License = License(
        javaResource as
            com.pulumi.azurenative.hybridcompute.License,
    )
}

/**
 * @see [License].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [License].
 */
public suspend fun license(name: String, block: suspend LicenseResourceBuilder.() -> Unit):
    License {
    val builder = LicenseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [License].
 * @param name The _unique_ name of the resulting resource.
 */
public fun license(name: String): License {
    val builder = LicenseResourceBuilder()
    builder.name(name)
    return builder.build()
}
