@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.kotlin.outputs.AgentConfigurationResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.AgentUpgradeResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.CloudMetadataResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.ErrorDetailResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.LocationDataResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionInstanceViewResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.OSProfileResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.ServiceStatusesResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.AgentConfigurationResponse.Companion.toKotlin as agentConfigurationResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.AgentUpgradeResponse.Companion.toKotlin as agentUpgradeResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.CloudMetadataResponse.Companion.toKotlin as cloudMetadataResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin as errorDetailResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.LocationDataResponse.Companion.toKotlin as locationDataResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionInstanceViewResponse.Companion.toKotlin as machineExtensionInstanceViewResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionResponse.Companion.toKotlin as machineExtensionResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.OSProfileResponse.Companion.toKotlin as oSProfileResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.ServiceStatusesResponse.Companion.toKotlin as serviceStatusesResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Machine].
 */
@PulumiTagMarker
public class MachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineArgs = MachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineArgsBuilder.() -> Unit) {
        val builder = MachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Machine {
        val builtJavaResource = com.pulumi.azurenative.hybridcompute.Machine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Machine(builtJavaResource)
    }
}

/**
 * Describes a hybrid machine.
 * Azure REST API version: 2022-12-27. Prior API version in Azure Native 1.x: 2020-08-02.
 * Other available API versions: 2019-03-18-preview, 2019-08-02-preview, 2020-08-02, 2020-08-15-preview, 2022-05-10-preview, 2023-06-20-preview, 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a Machine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machine = new AzureNative.HybridCompute.Machine("machine", new()
 *     {
 *         ClientPublicKey = "string",
 *         Identity = new AzureNative.HybridCompute.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.HybridCompute.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus2euap",
 *         LocationData = new AzureNative.HybridCompute.Inputs.LocationDataArgs
 *         {
 *             Name = "Redmond",
 *         },
 *         MachineName = "myMachine",
 *         ParentClusterResourceId = "{AzureStackHCIResourceId}",
 *         PrivateLinkScopeResourceId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName",
 *         ResourceGroupName = "myResourceGroup",
 *         VmId = "b7a098cc-b0b8-46e8-a205-62f301a62a8f",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewMachine(ctx, "machine", &hybridcompute.MachineArgs{
 * 			ClientPublicKey: pulumi.String("string"),
 * 			Identity: &hybridcompute.IdentityArgs{
 * 				Type: hybridcompute.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location: pulumi.String("eastus2euap"),
 * 			LocationData: &hybridcompute.LocationDataArgs{
 * 				Name: pulumi.String("Redmond"),
 * 			},
 * 			MachineName:                pulumi.String("myMachine"),
 * 			ParentClusterResourceId:    pulumi.String("{AzureStackHCIResourceId}"),
 * 			PrivateLinkScopeResourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			VmId:                       pulumi.String("b7a098cc-b0b8-46e8-a205-62f301a62a8f"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.Machine;
 * import com.pulumi.azurenative.hybridcompute.MachineArgs;
 * import com.pulumi.azurenative.hybridcompute.inputs.IdentityArgs;
 * import com.pulumi.azurenative.hybridcompute.inputs.LocationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machine = new Machine("machine", MachineArgs.builder()
 *             .clientPublicKey("string")
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus2euap")
 *             .locationData(LocationDataArgs.builder()
 *                 .name("Redmond")
 *                 .build())
 *             .machineName("myMachine")
 *             .parentClusterResourceId("{AzureStackHCIResourceId}")
 *             .privateLinkScopeResourceId("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName")
 *             .resourceGroupName("myResourceGroup")
 *             .vmId("b7a098cc-b0b8-46e8-a205-62f301a62a8f")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:Machine myMachine /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}
 * ```
 */
public class Machine internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcompute.Machine,
) : KotlinCustomResource(javaResource, MachineMapper) {
    /**
     * Specifies the AD fully qualified display name.
     */
    public val adFqdn: Output<String>
        get() = javaResource.adFqdn().applyValue({ args0 -> args0 })

    /**
     * Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
     */
    public val agentConfiguration: Output<AgentConfigurationResponse>
        get() = javaResource.agentConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                agentConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The info of the machine w.r.t Agent Upgrade
     */
    public val agentUpgrade: Output<AgentUpgradeResponse>?
        get() = javaResource.agentUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentUpgradeResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The hybrid machine agent full version.
     */
    public val agentVersion: Output<String>
        get() = javaResource.agentVersion().applyValue({ args0 -> args0 })

    /**
     * Public Key that the client provides to be used during initial resource onboarding
     */
    public val clientPublicKey: Output<String>?
        get() = javaResource.clientPublicKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
     */
    public val cloudMetadata: Output<CloudMetadataResponse>?
        get() = javaResource.cloudMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cloudMetadataResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Detected properties from the machine.
     */
    public val detectedProperties: Output<Map<String, String>>
        get() = javaResource.detectedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the hybrid machine display name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Specifies the DNS fully qualified display name.
     */
    public val dnsFqdn: Output<String>
        get() = javaResource.dnsFqdn().applyValue({ args0 -> args0 })

    /**
     * Specifies the Windows domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Details about the error state.
     */
    public val errorDetails: Output<List<ErrorDetailResponse>>
        get() = javaResource.errorDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    errorDetailResponseToKotlin(args0)
                })
            })
        })

    /**
     * Machine Extensions information (deprecated field)
     */
    public val extensions: Output<List<MachineExtensionInstanceViewResponse>>?
        get() = javaResource.extensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> machineExtensionInstanceViewResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The time of the last status change.
     */
    public val lastStatusChange: Output<String>
        get() = javaResource.lastStatusChange().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to the geographic location of the resource.
     */
    public val locationData: Output<LocationDataResponse>?
        get() = javaResource.locationData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    locationDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the hybrid machine FQDN.
     */
    public val machineFqdn: Output<String>
        get() = javaResource.machineFqdn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether any MS SQL instance is discovered on the machine.
     */
    public val mssqlDiscovered: Output<String>?
        get() = javaResource.mssqlDiscovered().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Operating System running on the hybrid machine.
     */
    public val osName: Output<String>
        get() = javaResource.osName().applyValue({ args0 -> args0 })

    /**
     * Specifies the operating system settings for the hybrid machine.
     */
    public val osProfile: Output<OSProfileResponse>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    oSProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the Operating System product SKU.
     */
    public val osSku: Output<String>
        get() = javaResource.osSku().applyValue({ args0 -> args0 })

    /**
     * The type of Operating System (windows/linux).
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The version of Operating System running on the hybrid machine.
     */
    public val osVersion: Output<String>
        get() = javaResource.osVersion().applyValue({ args0 -> args0 })

    /**
     * The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
     */
    public val parentClusterResourceId: Output<String>?
        get() = javaResource.parentClusterResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource id of the private link scope this machine is assigned to, if any.
     */
    public val privateLinkScopeResourceId: Output<String>?
        get() = javaResource.privateLinkScopeResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The list of extensions affiliated to the machine
     */
    public val resources: Output<List<MachineExtensionResponse>>
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    machineExtensionResponseToKotlin(args0)
                })
            })
        })

    /**
     * Statuses of dependent services that are reported back to ARM.
     */
    public val serviceStatuses: Output<ServiceStatusesResponse>?
        get() = javaResource.serviceStatuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceStatusesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The status of the hybrid machine agent.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the hybrid machine unique ID.
     */
    public val vmId: Output<String>?
        get() = javaResource.vmId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the Arc Machine's unique SMBIOS ID
     */
    public val vmUuid: Output<String>
        get() = javaResource.vmUuid().applyValue({ args0 -> args0 })
}

public object MachineMapper : ResourceMapper<Machine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcompute.Machine::class == javaResource::class

    override fun map(javaResource: Resource): Machine = Machine(
        javaResource as
            com.pulumi.azurenative.hybridcompute.Machine,
    )
}

/**
 * @see [Machine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Machine].
 */
public suspend fun machine(name: String, block: suspend MachineResourceBuilder.() -> Unit):
    Machine {
    val builder = MachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Machine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machine(name: String): Machine {
    val builder = MachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
