@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionPropertiesResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionPropertiesResponse.Companion.toKotlin as machineExtensionPropertiesResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MachineExtension].
 */
@PulumiTagMarker
public class MachineExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineExtensionArgs = MachineExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineExtensionArgsBuilder.() -> Unit) {
        val builder = MachineExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MachineExtension {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcompute.MachineExtension(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MachineExtension(builtJavaResource)
    }
}

/**
 * Describes a Machine Extension.
 * Azure REST API version: 2022-12-27. Prior API version in Azure Native 1.x: 2020-08-02.
 * Other available API versions: 2019-08-02-preview, 2020-08-15-preview, 2022-05-10-preview, 2023-06-20-preview, 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a Machine Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineExtension = new AzureNative.HybridCompute.MachineExtension("machineExtension", new()
 *     {
 *         ExtensionName = "CustomScriptExtension",
 *         Location = "eastus2euap",
 *         MachineName = "myMachine",
 *         Properties = new AzureNative.HybridCompute.Inputs.MachineExtensionPropertiesArgs
 *         {
 *             Publisher = "Microsoft.Compute",
 *             Settings = new Dictionary<string, object?>
 *             {
 *                 ["commandToExecute"] = "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"",
 *             },
 *             Type = "CustomScriptExtension",
 *             TypeHandlerVersion = "1.10",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewMachineExtension(ctx, "machineExtension", &hybridcompute.MachineExtensionArgs{
 * 			ExtensionName: pulumi.String("CustomScriptExtension"),
 * 			Location:      pulumi.String("eastus2euap"),
 * 			MachineName:   pulumi.String("myMachine"),
 * 			Properties: &hybridcompute.MachineExtensionPropertiesArgs{
 * 				Publisher: pulumi.String("Microsoft.Compute"),
 * 				Settings: pulumi.Any(map[string]interface{}{
 * 					"commandToExecute": "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\"",
 * 				}),
 * 				Type:               pulumi.String("CustomScriptExtension"),
 * 				TypeHandlerVersion: pulumi.String("1.10"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.MachineExtension;
 * import com.pulumi.azurenative.hybridcompute.MachineExtensionArgs;
 * import com.pulumi.azurenative.hybridcompute.inputs.MachineExtensionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineExtension = new MachineExtension("machineExtension", MachineExtensionArgs.builder()
 *             .extensionName("CustomScriptExtension")
 *             .location("eastus2euap")
 *             .machineName("myMachine")
 *             .properties(MachineExtensionPropertiesArgs.builder()
 *                 .publisher("Microsoft.Compute")
 *                 .settings(Map.of("commandToExecute", "powershell.exe -c \"Get-Process | Where-Object { $_.CPU -gt 10000 }\""))
 *                 .type("CustomScriptExtension")
 *                 .typeHandlerVersion("1.10")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:MachineExtension CustomScriptExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/extensions/{extensionName}
 * ```
 */
public class MachineExtension internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcompute.MachineExtension,
) : KotlinCustomResource(javaResource, MachineExtensionMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes Machine Extension Properties.
     */
    public val properties: Output<MachineExtensionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                machineExtensionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MachineExtensionMapper : ResourceMapper<MachineExtension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcompute.MachineExtension::class == javaResource::class

    override fun map(javaResource: Resource): MachineExtension = MachineExtension(
        javaResource as
            com.pulumi.azurenative.hybridcompute.MachineExtension,
    )
}

/**
 * @see [MachineExtension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MachineExtension].
 */
public suspend fun machineExtension(
    name: String,
    block: suspend MachineExtensionResourceBuilder.() -> Unit,
): MachineExtension {
    val builder = MachineExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MachineExtension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machineExtension(name: String): MachineExtension {
    val builder = MachineExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
