@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.GetLicenseProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property licenseProfileName The name of the license profile.
 * @property machineName The name of the hybrid machine.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLicenseProfilePlainArgs(
    public val licenseProfileName: String,
    public val machineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.GetLicenseProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.GetLicenseProfilePlainArgs =
        com.pulumi.azurenative.hybridcompute.inputs.GetLicenseProfilePlainArgs.builder()
            .licenseProfileName(licenseProfileName.let({ args0 -> args0 }))
            .machineName(machineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLicenseProfilePlainArgs].
 */
@PulumiTagMarker
public class GetLicenseProfilePlainArgsBuilder internal constructor() {
    private var licenseProfileName: String? = null

    private var machineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the license profile.
     */
    @JvmName("fjdhcbnqtphdgrwh")
    public suspend fun licenseProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.licenseProfileName = mapped
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("akmqdppopaonmmpi")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.machineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cwraktpqbpwqhdol")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLicenseProfilePlainArgs = GetLicenseProfilePlainArgs(
        licenseProfileName = licenseProfileName ?: throw PulumiNullFieldException("licenseProfileName"),
        machineName = machineName ?: throw PulumiNullFieldException("machineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
