@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.LicenseDetailsArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.enums.LicenseCoreType
import com.pulumi.azurenative.hybridcompute.kotlin.enums.LicenseEdition
import com.pulumi.azurenative.hybridcompute.kotlin.enums.LicenseState
import com.pulumi.azurenative.hybridcompute.kotlin.enums.LicenseTarget
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of a License.
 * @property edition Describes the edition of the license. The values are either Standard or Datacenter.
 * @property processors Describes the number of processors.
 * @property state Describes the state of the license.
 * @property target Describes the license target server.
 * @property type Describes the license core type (pCore or vCore).
 */
public data class LicenseDetailsArgs(
    public val edition: Output<Either<String, LicenseEdition>>? = null,
    public val processors: Output<Int>? = null,
    public val state: Output<Either<String, LicenseState>>? = null,
    public val target: Output<Either<String, LicenseTarget>>? = null,
    public val type: Output<Either<String, LicenseCoreType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.LicenseDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.LicenseDetailsArgs =
        com.pulumi.azurenative.hybridcompute.inputs.LicenseDetailsArgs.builder()
            .edition(
                edition?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .processors(processors?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .target(
                target?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LicenseDetailsArgs].
 */
@PulumiTagMarker
public class LicenseDetailsArgsBuilder internal constructor() {
    private var edition: Output<Either<String, LicenseEdition>>? = null

    private var processors: Output<Int>? = null

    private var state: Output<Either<String, LicenseState>>? = null

    private var target: Output<Either<String, LicenseTarget>>? = null

    private var type: Output<Either<String, LicenseCoreType>>? = null

    /**
     * @param value Describes the edition of the license. The values are either Standard or Datacenter.
     */
    @JvmName("bseykhkmlphlgplk")
    public suspend fun edition(`value`: Output<Either<String, LicenseEdition>>) {
        this.edition = value
    }

    /**
     * @param value Describes the number of processors.
     */
    @JvmName("mcriekpvcgpvqxfe")
    public suspend fun processors(`value`: Output<Int>) {
        this.processors = value
    }

    /**
     * @param value Describes the state of the license.
     */
    @JvmName("bhxiwlbiilkdfeqs")
    public suspend fun state(`value`: Output<Either<String, LicenseState>>) {
        this.state = value
    }

    /**
     * @param value Describes the license target server.
     */
    @JvmName("qgohrwkatrgfbuba")
    public suspend fun target(`value`: Output<Either<String, LicenseTarget>>) {
        this.target = value
    }

    /**
     * @param value Describes the license core type (pCore or vCore).
     */
    @JvmName("oltlbydqplgpqccq")
    public suspend fun type(`value`: Output<Either<String, LicenseCoreType>>) {
        this.type = value
    }

    /**
     * @param value Describes the edition of the license. The values are either Standard or Datacenter.
     */
    @JvmName("hheerevymutxbcgw")
    public suspend fun edition(`value`: Either<String, LicenseEdition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Describes the edition of the license. The values are either Standard or Datacenter.
     */
    @JvmName("vpgxegecwjbwjvdc")
    public fun edition(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseEdition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Describes the edition of the license. The values are either Standard or Datacenter.
     */
    @JvmName("yifjmjrledcfptey")
    public fun edition(`value`: LicenseEdition) {
        val toBeMapped = Either.ofRight<String, LicenseEdition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Describes the number of processors.
     */
    @JvmName("gctdqihpjxsimpdg")
    public suspend fun processors(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param value Describes the state of the license.
     */
    @JvmName("ffeaxwwmhtqjodpk")
    public suspend fun state(`value`: Either<String, LicenseState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Describes the state of the license.
     */
    @JvmName("bewemfhinvsvojix")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Describes the state of the license.
     */
    @JvmName("flpaupkevthqcscu")
    public fun state(`value`: LicenseState) {
        val toBeMapped = Either.ofRight<String, LicenseState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Describes the license target server.
     */
    @JvmName("oehnxvpbmdlfgdoo")
    public suspend fun target(`value`: Either<String, LicenseTarget>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Describes the license target server.
     */
    @JvmName("wooipoybrqxigtcn")
    public fun target(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseTarget>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Describes the license target server.
     */
    @JvmName("idjmgljpqhktlvmx")
    public fun target(`value`: LicenseTarget) {
        val toBeMapped = Either.ofRight<String, LicenseTarget>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Describes the license core type (pCore or vCore).
     */
    @JvmName("khstlhuuwcyqsrkd")
    public suspend fun type(`value`: Either<String, LicenseCoreType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Describes the license core type (pCore or vCore).
     */
    @JvmName("wyejqwdjjhxjautm")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseCoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Describes the license core type (pCore or vCore).
     */
    @JvmName("knjjdwxjfwqunufh")
    public fun type(`value`: LicenseCoreType) {
        val toBeMapped = Either.ofRight<String, LicenseCoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LicenseDetailsArgs = LicenseDetailsArgs(
        edition = edition,
        processors = processors,
        state = state,
        target = target,
        type = type,
    )
}
