@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.OSProfileLinuxConfigurationArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.enums.AssessmentModeTypes
import com.pulumi.azurenative.hybridcompute.kotlin.enums.PatchModeTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the linux configuration for update management.
 * @property assessmentMode Specifies the assessment mode.
 * @property patchMode Specifies the patch mode.
 */
public data class OSProfileLinuxConfigurationArgs(
    public val assessmentMode: Output<Either<String, AssessmentModeTypes>>? = null,
    public val patchMode: Output<Either<String, PatchModeTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.OSProfileLinuxConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.OSProfileLinuxConfigurationArgs =
        com.pulumi.azurenative.hybridcompute.inputs.OSProfileLinuxConfigurationArgs.builder()
            .assessmentMode(
                assessmentMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .patchMode(
                patchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OSProfileLinuxConfigurationArgs].
 */
@PulumiTagMarker
public class OSProfileLinuxConfigurationArgsBuilder internal constructor() {
    private var assessmentMode: Output<Either<String, AssessmentModeTypes>>? = null

    private var patchMode: Output<Either<String, PatchModeTypes>>? = null

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("wxrnoiltuwwfmagn")
    public suspend fun assessmentMode(`value`: Output<Either<String, AssessmentModeTypes>>) {
        this.assessmentMode = value
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("lqpikwiqexsryuuy")
    public suspend fun patchMode(`value`: Output<Either<String, PatchModeTypes>>) {
        this.patchMode = value
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("rqshnqukqlisdjqf")
    public suspend fun assessmentMode(`value`: Either<String, AssessmentModeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("omdqlixfhewurvsl")
    public fun assessmentMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("lvmlrjeyutnqfvti")
    public fun assessmentMode(`value`: AssessmentModeTypes) {
        val toBeMapped = Either.ofRight<String, AssessmentModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("cjwtqygwepbvwwgv")
    public suspend fun patchMode(`value`: Either<String, PatchModeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("dtlmkjvuahmpqevq")
    public fun patchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PatchModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("hmhqxfjfhgrjwtum")
    public fun patchMode(`value`: PatchModeTypes) {
        val toBeMapped = Either.ofRight<String, PatchModeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    internal fun build(): OSProfileLinuxConfigurationArgs = OSProfileLinuxConfigurationArgs(
        assessmentMode = assessmentMode,
        patchMode = patchMode,
    )
}
