@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Reports the state and behavior of dependent services.
 * @property extensionService The state of the extension service on the Arc-enabled machine.
 * @property guestConfigurationService The state of the guest configuration service on the Arc-enabled machine.
 */
public data class ServiceStatusesArgs(
    public val extensionService: Output<ServiceStatusArgs>? = null,
    public val guestConfigurationService: Output<ServiceStatusArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusesArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusesArgs =
        com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusesArgs.builder()
            .extensionService(extensionService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .guestConfigurationService(
                guestConfigurationService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceStatusesArgs].
 */
@PulumiTagMarker
public class ServiceStatusesArgsBuilder internal constructor() {
    private var extensionService: Output<ServiceStatusArgs>? = null

    private var guestConfigurationService: Output<ServiceStatusArgs>? = null

    /**
     * @param value The state of the extension service on the Arc-enabled machine.
     */
    @JvmName("hqrykduvsdavrvwt")
    public suspend fun extensionService(`value`: Output<ServiceStatusArgs>) {
        this.extensionService = value
    }

    /**
     * @param value The state of the guest configuration service on the Arc-enabled machine.
     */
    @JvmName("tovisivhhoundptd")
    public suspend fun guestConfigurationService(`value`: Output<ServiceStatusArgs>) {
        this.guestConfigurationService = value
    }

    /**
     * @param value The state of the extension service on the Arc-enabled machine.
     */
    @JvmName("xhmoubbyegtjmkpv")
    public suspend fun extensionService(`value`: ServiceStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionService = mapped
    }

    /**
     * @param argument The state of the extension service on the Arc-enabled machine.
     */
    @JvmName("gfmdjfogyrsopawp")
    public suspend fun extensionService(argument: suspend ServiceStatusArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extensionService = mapped
    }

    /**
     * @param value The state of the guest configuration service on the Arc-enabled machine.
     */
    @JvmName("fcbxyeogtkmbhlnh")
    public suspend fun guestConfigurationService(`value`: ServiceStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestConfigurationService = mapped
    }

    /**
     * @param argument The state of the guest configuration service on the Arc-enabled machine.
     */
    @JvmName("fmigrepdnkclegqi")
    public suspend
    fun guestConfigurationService(argument: suspend ServiceStatusArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.guestConfigurationService = mapped
    }

    internal fun build(): ServiceStatusesArgs = ServiceStatusesArgs(
        extensionService = extensionService,
        guestConfigurationService = guestConfigurationService,
    )
}
