@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a license profile in a hybrid machine.
 * @property assignedLicense The resource id of the license.
 * @property assignedLicenseImmutableId The guid id of the license.
 * @property esuEligibility Indicates the eligibility state of Esu.
 * @property esuKeyState Indicates whether there is an ESU Key currently active for the machine.
 * @property esuKeys The list of ESU keys.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property serverType The type of the Esu servers.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLicenseProfileResult(
    public val assignedLicense: String? = null,
    public val assignedLicenseImmutableId: String,
    public val esuEligibility: String,
    public val esuKeyState: String,
    public val esuKeys: List<EsuKeyResponse>,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val serverType: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.GetLicenseProfileResult):
            GetLicenseProfileResult = GetLicenseProfileResult(
            assignedLicense = javaType.assignedLicense().map({ args0 -> args0 }).orElse(null),
            assignedLicenseImmutableId = javaType.assignedLicenseImmutableId(),
            esuEligibility = javaType.esuEligibility(),
            esuKeyState = javaType.esuKeyState(),
            esuKeys = javaType.esuKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.EsuKeyResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serverType = javaType.serverType(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
