@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridconnectivity.kotlin.inputs

import com.pulumi.azurenative.hybridconnectivity.inputs.GetEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName The endpoint name.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 */
public data class GetEndpointPlainArgs(
    public val endpointName: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridconnectivity.inputs.GetEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridconnectivity.inputs.GetEndpointPlainArgs =
        com.pulumi.azurenative.hybridconnectivity.inputs.GetEndpointPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The endpoint name.
     */
    @JvmName("xaldxubyxnaopjlc")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("fwibgpcmsahlgkyj")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetEndpointPlainArgs = GetEndpointPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
