@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatumArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClusterIdentityArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.ProvisionedClusterIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the hybridIdentityMetadata.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2022-05-01-preview, 2023-11-15-preview, 2024-01-01.
 * ## Example Usage
 * ### CreateHybridIdentityMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridIdentityMetadatum = new AzureNative.HybridContainerService.HybridIdentityMetadatum("hybridIdentityMetadatum", new()
 *     {
 *         HybridIdentityMetadataResourceName = "default",
 *         PublicKey = "8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2",
 *         ResourceGroupName = "testrg",
 *         ResourceName = "ContosoTargetCluster",
 *         ResourceUid = "f8b82dff-38ef-4220-99ef-d3a3f86ddc6c",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewHybridIdentityMetadatum(ctx, "hybridIdentityMetadatum", &hybridcontainerservice.HybridIdentityMetadatumArgs{
 * 			HybridIdentityMetadataResourceName: pulumi.String("default"),
 * 			PublicKey:                          pulumi.String("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2"),
 * 			ResourceGroupName:                  pulumi.String("testrg"),
 * 			ResourceName:                       pulumi.String("ContosoTargetCluster"),
 * 			ResourceUid:                        pulumi.String("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatum;
 * import com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatumArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridIdentityMetadatum = new HybridIdentityMetadatum("hybridIdentityMetadatum", HybridIdentityMetadatumArgs.builder()
 *             .hybridIdentityMetadataResourceName("default")
 *             .publicKey("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2")
 *             .resourceGroupName("testrg")
 *             .resourceName("ContosoTargetCluster")
 *             .resourceUid("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:HybridIdentityMetadatum default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/provisionedClusters/{resourceName}/hybridIdentityMetadata/{hybridIdentityMetadataResourceName}
 * ```
 * @property hybridIdentityMetadataResourceName Parameter for the name of the hybrid identity metadata resource.
 * @property identity The identity of the provisioned cluster.
 * @property publicKey Onboarding public key for provisioning the Managed identity for the HybridAKS cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Parameter for the name of the provisioned cluster
 * @property resourceUid Unique id of the parent provisioned cluster resource.
 */
public data class HybridIdentityMetadatumArgs(
    public val hybridIdentityMetadataResourceName: Output<String>? = null,
    public val identity: Output<ProvisionedClusterIdentityArgs>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceUid: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatumArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatumArgs =
        com.pulumi.azurenative.hybridcontainerservice.HybridIdentityMetadatumArgs.builder()
            .hybridIdentityMetadataResourceName(
                hybridIdentityMetadataResourceName?.applyValue({ args0 ->
                    args0
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceUid(resourceUid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridIdentityMetadatumArgs].
 */
@PulumiTagMarker
public class HybridIdentityMetadatumArgsBuilder internal constructor() {
    private var hybridIdentityMetadataResourceName: Output<String>? = null

    private var identity: Output<ProvisionedClusterIdentityArgs>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceUid: Output<String>? = null

    /**
     * @param value Parameter for the name of the hybrid identity metadata resource.
     */
    @JvmName("exfwmqrdmhfwjdsc")
    public suspend fun hybridIdentityMetadataResourceName(`value`: Output<String>) {
        this.hybridIdentityMetadataResourceName = value
    }

    /**
     * @param value The identity of the provisioned cluster.
     */
    @JvmName("medhgyhfcerugncg")
    public suspend fun identity(`value`: Output<ProvisionedClusterIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Onboarding public key for provisioning the Managed identity for the HybridAKS cluster.
     */
    @JvmName("mbunrqmjsecynkcf")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kymsekwmfysayury")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("xtbiglbpbvbocysx")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Unique id of the parent provisioned cluster resource.
     */
    @JvmName("fcofuiwhpdjgiqgt")
    public suspend fun resourceUid(`value`: Output<String>) {
        this.resourceUid = value
    }

    /**
     * @param value Parameter for the name of the hybrid identity metadata resource.
     */
    @JvmName("qcrumrdyaasptoci")
    public suspend fun hybridIdentityMetadataResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridIdentityMetadataResourceName = mapped
    }

    /**
     * @param value The identity of the provisioned cluster.
     */
    @JvmName("pqwrimwxikjgykxd")
    public suspend fun identity(`value`: ProvisionedClusterIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the provisioned cluster.
     */
    @JvmName("qhemhvpgbnhkepml")
    public suspend fun identity(argument: suspend ProvisionedClusterIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedClusterIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Onboarding public key for provisioning the Managed identity for the HybridAKS cluster.
     */
    @JvmName("rshyjshgwlhsnfwu")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wiusunfdxbvplkqy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the provisioned cluster
     */
    @JvmName("eiwljoobluwlqdqr")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Unique id of the parent provisioned cluster resource.
     */
    @JvmName("fidryivlgswxjyan")
    public suspend fun resourceUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUid = mapped
    }

    internal fun build(): HybridIdentityMetadatumArgs = HybridIdentityMetadatumArgs(
        hybridIdentityMetadataResourceName = hybridIdentityMetadataResourceName,
        identity = identity,
        publicKey = publicKey,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        resourceUid = resourceUid,
    )
}
