@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesPropertiesResponse
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesResponseExtendedLocation
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesPropertiesResponse.Companion.toKotlin as storageSpacesPropertiesResponseToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.StorageSpacesResponseExtendedLocation.Companion.toKotlin as storageSpacesResponseExtendedLocationToKotlin
import com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StorageSpaceRetrieve].
 */
@PulumiTagMarker
public class StorageSpaceRetrieveResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageSpaceRetrieveArgs = StorageSpaceRetrieveArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageSpaceRetrieveArgsBuilder.() -> Unit) {
        val builder = StorageSpaceRetrieveArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageSpaceRetrieve {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieve(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageSpaceRetrieve(builtJavaResource)
    }
}

/**
 * The storageSpaces resource definition.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### PutStorageSpace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageSpaceRetrieve = new AzureNative.HybridContainerService.StorageSpaceRetrieve("storageSpaceRetrieve", new()
 *     {
 *         ExtendedLocation = new AzureNative.HybridContainerService.Inputs.StorageSpacesExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "westus",
 *         Properties = new AzureNative.HybridContainerService.Inputs.StorageSpacesPropertiesArgs
 *         {
 *             HciStorageProfile = new AzureNative.HybridContainerService.Inputs.StorageSpacesPropertiesHciStorageProfileArgs
 *             {
 *                 MocGroup = "target-group",
 *                 MocLocation = "MocLocation",
 *                 MocStorageContainer = "WssdStorageContainer",
 *             },
 *         },
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         StorageSpacesName = "test-storage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewStorageSpaceRetrieve(ctx, "storageSpaceRetrieve", &hybridcontainerservice.StorageSpaceRetrieveArgs{
 * 			ExtendedLocation: &hybridcontainerservice.StorageSpacesExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Properties: &hybridcontainerservice.StorageSpacesPropertiesArgs{
 * 				HciStorageProfile: &hybridcontainerservice.StorageSpacesPropertiesHciStorageProfileArgs{
 * 					MocGroup:            pulumi.String("target-group"),
 * 					MocLocation:         pulumi.String("MocLocation"),
 * 					MocStorageContainer: pulumi.String("WssdStorageContainer"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-arcappliance-resgrp"),
 * 			StorageSpacesName: pulumi.String("test-storage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieve;
 * import com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieveArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesExtendedLocationArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesHciStorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageSpaceRetrieve = new StorageSpaceRetrieve("storageSpaceRetrieve", StorageSpaceRetrieveArgs.builder()
 *             .extendedLocation(StorageSpacesExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("westus")
 *             .properties(StorageSpacesPropertiesArgs.builder()
 *                 .hciStorageProfile(StorageSpacesPropertiesHciStorageProfileArgs.builder()
 *                     .mocGroup("target-group")
 *                     .mocLocation("MocLocation")
 *                     .mocStorageContainer("WssdStorageContainer")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .storageSpacesName("test-storage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:StorageSpaceRetrieve test-storage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpacesName}
 * ```
 */
public class StorageSpaceRetrieve internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieve,
) : KotlinCustomResource(javaResource, StorageSpaceRetrieveMapper) {
    public val extendedLocation: Output<StorageSpacesResponseExtendedLocation>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageSpacesResponseExtendedLocationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * HybridAKSStorageSpec defines the desired state of HybridAKSStorage
     */
    public val properties: Output<StorageSpacesPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                storageSpacesPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageSpaceRetrieveMapper : ResourceMapper<StorageSpaceRetrieve> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieve::class == javaResource::class

    override fun map(javaResource: Resource): StorageSpaceRetrieve = StorageSpaceRetrieve(
        javaResource
            as com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieve,
    )
}

/**
 * @see [StorageSpaceRetrieve].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageSpaceRetrieve].
 */
public suspend fun storageSpaceRetrieve(
    name: String,
    block: suspend StorageSpaceRetrieveResourceBuilder.() -> Unit,
): StorageSpaceRetrieve {
    val builder = StorageSpaceRetrieveResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageSpaceRetrieve].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageSpaceRetrieve(name: String): StorageSpaceRetrieve {
    val builder = StorageSpaceRetrieveResourceBuilder()
    builder.name(name)
    return builder.build()
}
