@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieveArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.StorageSpacesExtendedLocationArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.StorageSpacesExtendedLocationArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.StorageSpacesPropertiesArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.StorageSpacesPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The storageSpaces resource definition.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### PutStorageSpace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageSpaceRetrieve = new AzureNative.HybridContainerService.StorageSpaceRetrieve("storageSpaceRetrieve", new()
 *     {
 *         ExtendedLocation = new AzureNative.HybridContainerService.Inputs.StorageSpacesExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "westus",
 *         Properties = new AzureNative.HybridContainerService.Inputs.StorageSpacesPropertiesArgs
 *         {
 *             HciStorageProfile = new AzureNative.HybridContainerService.Inputs.StorageSpacesPropertiesHciStorageProfileArgs
 *             {
 *                 MocGroup = "target-group",
 *                 MocLocation = "MocLocation",
 *                 MocStorageContainer = "WssdStorageContainer",
 *             },
 *         },
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         StorageSpacesName = "test-storage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewStorageSpaceRetrieve(ctx, "storageSpaceRetrieve", &hybridcontainerservice.StorageSpaceRetrieveArgs{
 * 			ExtendedLocation: &hybridcontainerservice.StorageSpacesExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Properties: &hybridcontainerservice.StorageSpacesPropertiesArgs{
 * 				HciStorageProfile: &hybridcontainerservice.StorageSpacesPropertiesHciStorageProfileArgs{
 * 					MocGroup:            pulumi.String("target-group"),
 * 					MocLocation:         pulumi.String("MocLocation"),
 * 					MocStorageContainer: pulumi.String("WssdStorageContainer"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-arcappliance-resgrp"),
 * 			StorageSpacesName: pulumi.String("test-storage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieve;
 * import com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieveArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesExtendedLocationArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesHciStorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageSpaceRetrieve = new StorageSpaceRetrieve("storageSpaceRetrieve", StorageSpaceRetrieveArgs.builder()
 *             .extendedLocation(StorageSpacesExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("westus")
 *             .properties(StorageSpacesPropertiesArgs.builder()
 *                 .hciStorageProfile(StorageSpacesPropertiesHciStorageProfileArgs.builder()
 *                     .mocGroup("target-group")
 *                     .mocLocation("MocLocation")
 *                     .mocStorageContainer("WssdStorageContainer")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .storageSpacesName("test-storage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:StorageSpaceRetrieve test-storage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpacesName}
 * ```
 * @property extendedLocation
 * @property location The geo-location where the resource lives
 * @property properties HybridAKSStorageSpec defines the desired state of HybridAKSStorage
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageSpacesName Parameter for the name of the storage object
 * @property tags Resource tags.
 */
public data class StorageSpaceRetrieveArgs(
    public val extendedLocation: Output<StorageSpacesExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<StorageSpacesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageSpacesName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieveArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieveArgs =
        com.pulumi.azurenative.hybridcontainerservice.StorageSpaceRetrieveArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageSpacesName(storageSpacesName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageSpaceRetrieveArgs].
 */
@PulumiTagMarker
public class StorageSpaceRetrieveArgsBuilder internal constructor() {
    private var extendedLocation: Output<StorageSpacesExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<StorageSpacesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageSpacesName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("rcodbxqdleraapvq")
    public suspend fun extendedLocation(`value`: Output<StorageSpacesExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bgfjiiyrffjwrmqx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value HybridAKSStorageSpec defines the desired state of HybridAKSStorage
     */
    @JvmName("kmdsjkdwhxinpvwm")
    public suspend fun properties(`value`: Output<StorageSpacesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ubkmdlkvntldmnua")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameter for the name of the storage object
     */
    @JvmName("dybboatqcpllegvy")
    public suspend fun storageSpacesName(`value`: Output<String>) {
        this.storageSpacesName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fcikmamalufnlndn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ppfsnudpuplbucub")
    public suspend fun extendedLocation(`value`: StorageSpacesExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ajrcwsxglgccsifh")
    public suspend
    fun extendedLocation(argument: suspend StorageSpacesExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSpacesExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jgagfgpsjqtxpsop")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value HybridAKSStorageSpec defines the desired state of HybridAKSStorage
     */
    @JvmName("opgdmmpaawddbdpu")
    public suspend fun properties(`value`: StorageSpacesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument HybridAKSStorageSpec defines the desired state of HybridAKSStorage
     */
    @JvmName("ygrqujiaaatkkhsf")
    public suspend fun properties(argument: suspend StorageSpacesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSpacesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qambarbnjtqfpoqg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the storage object
     */
    @JvmName("lvghoeffqrquuyrh")
    public suspend fun storageSpacesName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSpacesName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cvllnvldnvhwbncn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mmwfghqrdlsgfvot")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageSpaceRetrieveArgs = StorageSpaceRetrieveArgs(
        extendedLocation = extendedLocation,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        storageSpacesName = storageSpacesName,
        tags = tags,
    )
}
