@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin

import com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieveArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.VirtualNetworksExtendedLocationArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.VirtualNetworksExtendedLocationArgsBuilder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.VirtualNetworksPropertiesArgs
import com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs.VirtualNetworksPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The virtualNetworks resource definition.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * ## Example Usage
 * ### PutVirtualNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkRetrieve = new AzureNative.HybridContainerService.VirtualNetworkRetrieve("virtualNetworkRetrieve", new()
 *     {
 *         ExtendedLocation = new AzureNative.HybridContainerService.Inputs.VirtualNetworksExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "westus",
 *         Properties = new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesArgs
 *         {
 *             InfraVnetProfile = new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesInfraVnetProfileArgs
 *             {
 *                 Hci = new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesHciArgs
 *                 {
 *                     MocGroup = "target-group",
 *                     MocLocation = "MocLocation",
 *                     MocVnetName = "test-vnet",
 *                 },
 *             },
 *             VipPool = new[]
 *             {
 *                 new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesVipPoolArgs
 *                 {
 *                     EndIP = "192.168.0.50",
 *                     StartIP = "192.168.0.10",
 *                 },
 *             },
 *             VmipPool = new[]
 *             {
 *                 new AzureNative.HybridContainerService.Inputs.VirtualNetworksPropertiesVmipPoolArgs
 *                 {
 *                     EndIP = "192.168.0.130",
 *                     StartIP = "192.168.0.110",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-arcappliance-resgrp",
 *         VirtualNetworksName = "test-vnet-static",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcontainerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcontainerservice.NewVirtualNetworkRetrieve(ctx, "virtualNetworkRetrieve", &hybridcontainerservice.VirtualNetworkRetrieveArgs{
 * 			ExtendedLocation: &hybridcontainerservice.VirtualNetworksExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Properties: &hybridcontainerservice.VirtualNetworksPropertiesArgs{
 * 				InfraVnetProfile: &hybridcontainerservice.VirtualNetworksPropertiesInfraVnetProfileArgs{
 * 					Hci: &hybridcontainerservice.VirtualNetworksPropertiesHciArgs{
 * 						MocGroup:    pulumi.String("target-group"),
 * 						MocLocation: pulumi.String("MocLocation"),
 * 						MocVnetName: pulumi.String("test-vnet"),
 * 					},
 * 				},
 * 				VipPool: hybridcontainerservice.VirtualNetworksPropertiesVipPoolArray{
 * 					&hybridcontainerservice.VirtualNetworksPropertiesVipPoolArgs{
 * 						EndIP:   pulumi.String("192.168.0.50"),
 * 						StartIP: pulumi.String("192.168.0.10"),
 * 					},
 * 				},
 * 				VmipPool: hybridcontainerservice.VirtualNetworksPropertiesVmipPoolArray{
 * 					&hybridcontainerservice.VirtualNetworksPropertiesVmipPoolArgs{
 * 						EndIP:   pulumi.String("192.168.0.130"),
 * 						StartIP: pulumi.String("192.168.0.110"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("test-arcappliance-resgrp"),
 * 			VirtualNetworksName: pulumi.String("test-vnet-static"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieve;
 * import com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieveArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksExtendedLocationArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesInfraVnetProfileArgs;
 * import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesHciArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkRetrieve = new VirtualNetworkRetrieve("virtualNetworkRetrieve", VirtualNetworkRetrieveArgs.builder()
 *             .extendedLocation(VirtualNetworksExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("westus")
 *             .properties(VirtualNetworksPropertiesArgs.builder()
 *                 .infraVnetProfile(VirtualNetworksPropertiesInfraVnetProfileArgs.builder()
 *                     .hci(VirtualNetworksPropertiesHciArgs.builder()
 *                         .mocGroup("target-group")
 *                         .mocLocation("MocLocation")
 *                         .mocVnetName("test-vnet")
 *                         .build())
 *                     .build())
 *                 .vipPool(VirtualNetworksPropertiesVipPoolArgs.builder()
 *                     .endIP("192.168.0.50")
 *                     .startIP("192.168.0.10")
 *                     .build())
 *                 .vmipPool(VirtualNetworksPropertiesVmipPoolArgs.builder()
 *                     .endIP("192.168.0.130")
 *                     .startIP("192.168.0.110")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-arcappliance-resgrp")
 *             .virtualNetworksName("test-vnet-static")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcontainerservice:VirtualNetworkRetrieve test-vnet-static /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworksName}
 * ```
 * @property extendedLocation
 * @property location The geo-location where the resource lives
 * @property properties HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property virtualNetworksName Parameter for the name of the virtual network
 */
public data class VirtualNetworkRetrieveArgs(
    public val extendedLocation: Output<VirtualNetworksExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<VirtualNetworksPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetworksName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieveArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieveArgs =
        com.pulumi.azurenative.hybridcontainerservice.VirtualNetworkRetrieveArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetworksName(virtualNetworksName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkRetrieveArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRetrieveArgsBuilder internal constructor() {
    private var extendedLocation: Output<VirtualNetworksExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<VirtualNetworksPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetworksName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lpcinklhgthfndwu")
    public suspend fun extendedLocation(`value`: Output<VirtualNetworksExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qvxiwnujmdhrwqkn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
     */
    @JvmName("lwvaefxvwwrhuxpg")
    public suspend fun properties(`value`: Output<VirtualNetworksPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("havtpomrfeiwcdke")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ruilhveqrmgllydi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Parameter for the name of the virtual network
     */
    @JvmName("wwftolrhknidfbfl")
    public suspend fun virtualNetworksName(`value`: Output<String>) {
        this.virtualNetworksName = value
    }

    /**
     * @param value
     */
    @JvmName("eekhleywebweqllr")
    public suspend fun extendedLocation(`value`: VirtualNetworksExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument
     */
    @JvmName("daumvqaphnrrylbv")
    public suspend
    fun extendedLocation(argument: suspend VirtualNetworksExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworksExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fuidhhcbyxpdcigo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
     */
    @JvmName("cvwuakkrmhnldxes")
    public suspend fun properties(`value`: VirtualNetworksPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
     */
    @JvmName("byggktcgnpmpqrfa")
    public suspend fun properties(argument: suspend VirtualNetworksPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworksPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iisqyouvxjdcyfxj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hpokgpruabciwvlx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jkgfsuauxmuynpfj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Parameter for the name of the virtual network
     */
    @JvmName("rqtylnngpninhmga")
    public suspend fun virtualNetworksName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworksName = mapped
    }

    internal fun build(): VirtualNetworkRetrieveArgs = VirtualNetworkRetrieveArgs(
        extendedLocation = extendedLocation,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualNetworksName = virtualNetworksName,
    )
}
