@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.AddonProfilesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Addon configurations
 * @property config Config - Key-value pairs for configuring an add-on.
 * @property enabled Enabled - Whether the add-on is enabled or not.
 */
public data class AddonProfilesArgs(
    public val config: Output<Map<String, String>>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.AddonProfilesArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.AddonProfilesArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.AddonProfilesArgs.builder()
            .config(config?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddonProfilesArgs].
 */
@PulumiTagMarker
public class AddonProfilesArgsBuilder internal constructor() {
    private var config: Output<Map<String, String>>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Config - Key-value pairs for configuring an add-on.
     */
    @JvmName("vyirfjlnreiujdoh")
    public suspend fun config(`value`: Output<Map<String, String>>) {
        this.config = value
    }

    /**
     * @param value Enabled - Whether the add-on is enabled or not.
     */
    @JvmName("fsewlabilbyaxfyx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Config - Key-value pairs for configuring an add-on.
     */
    @JvmName("yidqhcircribpvpy")
    public suspend fun config(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param values Config - Key-value pairs for configuring an add-on.
     */
    @JvmName("hrynjyphxnttcxru")
    public fun config(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value Enabled - Whether the add-on is enabled or not.
     */
    @JvmName("fthbgxqkwwptukav")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): AddonProfilesArgs = AddonProfilesArgs(
        config = config,
        enabled = enabled,
    )
}
