@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.HttpProxyConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configurations for provisioning the cluster with HTTP proxy servers.
 * @property httpProxy The HTTP proxy server endpoint to use.
 * @property httpsProxy The HTTPS proxy server endpoint to use.
 * @property noProxy The endpoints that should not go through proxy.
 * @property password Password to use for connecting to proxy server
 * @property trustedCa Alternative CA cert to use for connecting to proxy servers.
 * @property username Username to use for connecting to proxy server
 */
public data class HttpProxyConfigArgs(
    public val httpProxy: Output<String>? = null,
    public val httpsProxy: Output<String>? = null,
    public val noProxy: Output<List<String>>? = null,
    public val password: Output<String>? = null,
    public val trustedCa: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.HttpProxyConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.HttpProxyConfigArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.HttpProxyConfigArgs.builder()
            .httpProxy(httpProxy?.applyValue({ args0 -> args0 }))
            .httpsProxy(httpsProxy?.applyValue({ args0 -> args0 }))
            .noProxy(noProxy?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .password(password?.applyValue({ args0 -> args0 }))
            .trustedCa(trustedCa?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpProxyConfigArgs].
 */
@PulumiTagMarker
public class HttpProxyConfigArgsBuilder internal constructor() {
    private var httpProxy: Output<String>? = null

    private var httpsProxy: Output<String>? = null

    private var noProxy: Output<List<String>>? = null

    private var password: Output<String>? = null

    private var trustedCa: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The HTTP proxy server endpoint to use.
     */
    @JvmName("ygpcshctxojfkxuh")
    public suspend fun httpProxy(`value`: Output<String>) {
        this.httpProxy = value
    }

    /**
     * @param value The HTTPS proxy server endpoint to use.
     */
    @JvmName("kmblmyeaaqwivuyg")
    public suspend fun httpsProxy(`value`: Output<String>) {
        this.httpsProxy = value
    }

    /**
     * @param value The endpoints that should not go through proxy.
     */
    @JvmName("wxfaywgtmkayssqc")
    public suspend fun noProxy(`value`: Output<List<String>>) {
        this.noProxy = value
    }

    @JvmName("uqiegityxtxyrhwy")
    public suspend fun noProxy(vararg values: Output<String>) {
        this.noProxy = Output.all(values.asList())
    }

    /**
     * @param values The endpoints that should not go through proxy.
     */
    @JvmName("okmdrotutbygxwpw")
    public suspend fun noProxy(values: List<Output<String>>) {
        this.noProxy = Output.all(values)
    }

    /**
     * @param value Password to use for connecting to proxy server
     */
    @JvmName("bvjbkxsevqnfojeo")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Alternative CA cert to use for connecting to proxy servers.
     */
    @JvmName("txrcxnopctfxvdkr")
    public suspend fun trustedCa(`value`: Output<String>) {
        this.trustedCa = value
    }

    /**
     * @param value Username to use for connecting to proxy server
     */
    @JvmName("myfqohnxbitxxqlj")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The HTTP proxy server endpoint to use.
     */
    @JvmName("eucvwkieeysrrqgn")
    public suspend fun httpProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxy = mapped
    }

    /**
     * @param value The HTTPS proxy server endpoint to use.
     */
    @JvmName("rngwqqhkrtqvyyku")
    public suspend fun httpsProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsProxy = mapped
    }

    /**
     * @param value The endpoints that should not go through proxy.
     */
    @JvmName("gbeoevowhfylsjuc")
    public suspend fun noProxy(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noProxy = mapped
    }

    /**
     * @param values The endpoints that should not go through proxy.
     */
    @JvmName("wtnppqfewsosaqaa")
    public suspend fun noProxy(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noProxy = mapped
    }

    /**
     * @param value Password to use for connecting to proxy server
     */
    @JvmName("sbyruadlmnqxloyg")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Alternative CA cert to use for connecting to proxy servers.
     */
    @JvmName("nipannpaypamigxj")
    public suspend fun trustedCa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCa = mapped
    }

    /**
     * @param value Username to use for connecting to proxy server
     */
    @JvmName("fvcvyysuvtstekpp")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): HttpProxyConfigArgs = HttpProxyConfigArgs(
        httpProxy = httpProxy,
        httpsProxy = httpsProxy,
        noProxy = noProxy,
        password = password,
        trustedCa = trustedCa,
        username = username,
    )
}
