@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.NetworkProfileArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.LoadBalancerSku
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.NetworkPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NetworkProfile - Profile of network configuration.
 * @property dnsServiceIP DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
 * @property loadBalancerProfile LoadBalancerProfile - Profile of the cluster load balancer.
 * @property loadBalancerSku LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
 * @property networkPolicy NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
 * @property podCidr PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
 * @property podCidrs The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 * @property serviceCidr ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
 * @property serviceCidrs The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
 */
public data class NetworkProfileArgs(
    public val dnsServiceIP: Output<String>? = null,
    public val loadBalancerProfile: Output<LoadBalancerProfileArgs>? = null,
    public val loadBalancerSku: Output<Either<String, LoadBalancerSku>>? = null,
    public val networkPolicy: Output<Either<String, NetworkPolicy>>? = null,
    public val podCidr: Output<String>? = null,
    public val podCidrs: Output<List<String>>? = null,
    public val serviceCidr: Output<String>? = null,
    public val serviceCidrs: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.NetworkProfileArgs.builder()
            .dnsServiceIP(dnsServiceIP?.applyValue({ args0 -> args0 }))
            .loadBalancerProfile(
                loadBalancerProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .loadBalancerSku(
                loadBalancerSku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkPolicy(
                networkPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .podCidr(podCidr?.applyValue({ args0 -> args0 }))
            .podCidrs(podCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .serviceCidrs(serviceCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var dnsServiceIP: Output<String>? = null

    private var loadBalancerProfile: Output<LoadBalancerProfileArgs>? = null

    private var loadBalancerSku: Output<Either<String, LoadBalancerSku>>? = null

    private var networkPolicy: Output<Either<String, NetworkPolicy>>? = null

    private var podCidr: Output<String>? = null

    private var podCidrs: Output<List<String>>? = null

    private var serviceCidr: Output<String>? = null

    private var serviceCidrs: Output<List<String>>? = null

    /**
     * @param value DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
     */
    @JvmName("xojdhaxcgcnumvrj")
    public suspend fun dnsServiceIP(`value`: Output<String>) {
        this.dnsServiceIP = value
    }

    /**
     * @param value LoadBalancerProfile - Profile of the cluster load balancer.
     */
    @JvmName("tqecijimjvxveiig")
    public suspend fun loadBalancerProfile(`value`: Output<LoadBalancerProfileArgs>) {
        this.loadBalancerProfile = value
    }

    /**
     * @param value LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
     */
    @JvmName("povdrgkadptccptq")
    public suspend fun loadBalancerSku(`value`: Output<Either<String, LoadBalancerSku>>) {
        this.loadBalancerSku = value
    }

    /**
     * @param value NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
     */
    @JvmName("ykhwbikixbodtxbg")
    public suspend fun networkPolicy(`value`: Output<Either<String, NetworkPolicy>>) {
        this.networkPolicy = value
    }

    /**
     * @param value PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     */
    @JvmName("ehixxlogerdjfsps")
    public suspend fun podCidr(`value`: Output<String>) {
        this.podCidr = value
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("gaptxydmmemoqqeg")
    public suspend fun podCidrs(`value`: Output<List<String>>) {
        this.podCidrs = value
    }

    @JvmName("jlmejspwuuublqoq")
    public suspend fun podCidrs(vararg values: Output<String>) {
        this.podCidrs = Output.all(values.asList())
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("yfnijlvbctaalvjr")
    public suspend fun podCidrs(values: List<Output<String>>) {
        this.podCidrs = Output.all(values)
    }

    /**
     * @param value ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
     */
    @JvmName("fwqmmpgntyyhbxdv")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("nnkhhbfxujwqijgo")
    public suspend fun serviceCidrs(`value`: Output<List<String>>) {
        this.serviceCidrs = value
    }

    @JvmName("avnwdkpnehiqrxsr")
    public suspend fun serviceCidrs(vararg values: Output<String>) {
        this.serviceCidrs = Output.all(values.asList())
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("sxrxyanmxgqurlrn")
    public suspend fun serviceCidrs(values: List<Output<String>>) {
        this.serviceCidrs = Output.all(values)
    }

    /**
     * @param value DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
     */
    @JvmName("rugottriwwulkirs")
    public suspend fun dnsServiceIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServiceIP = mapped
    }

    /**
     * @param value LoadBalancerProfile - Profile of the cluster load balancer.
     */
    @JvmName("qdmcjaumbwyhjlqx")
    public suspend fun loadBalancerProfile(`value`: LoadBalancerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerProfile = mapped
    }

    /**
     * @param argument LoadBalancerProfile - Profile of the cluster load balancer.
     */
    @JvmName("juydxtcgpvygckas")
    public suspend
    fun loadBalancerProfile(argument: suspend LoadBalancerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerProfile = mapped
    }

    /**
     * @param value LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
     */
    @JvmName("cjwponpcgwmncmct")
    public suspend fun loadBalancerSku(`value`: Either<String, LoadBalancerSku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSku = mapped
    }

    /**
     * @param value LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
     */
    @JvmName("gaygwthjkmtrqxyc")
    public fun loadBalancerSku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerSku = mapped
    }

    /**
     * @param value LoadBalancerSku - The load balancer sku for the provisioned cluster. Possible values: 'unstacked-haproxy', 'stacked-kube-vip', 'stacked-metallb', 'unmanaged'. The default is 'unmanaged'.
     */
    @JvmName("rbdgcpxvocfrypgx")
    public fun loadBalancerSku(`value`: LoadBalancerSku) {
        val toBeMapped = Either.ofRight<String, LoadBalancerSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerSku = mapped
    }

    /**
     * @param value NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
     */
    @JvmName("myonchrdljkpfhrt")
    public suspend fun networkPolicy(`value`: Either<String, NetworkPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkPolicy = mapped
    }

    /**
     * @param value NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
     */
    @JvmName("qxeboseptidvaupi")
    public fun networkPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPolicy = mapped
    }

    /**
     * @param value NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default is 'calico'
     */
    @JvmName("iknihbilnfadpsnx")
    public fun networkPolicy(`value`: NetworkPolicy) {
        val toBeMapped = Either.ofRight<String, NetworkPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPolicy = mapped
    }

    /**
     * @param value PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     */
    @JvmName("flqpwnbxlgsalhln")
    public suspend fun podCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidr = mapped
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("timesormwrcgrwkj")
    public suspend fun podCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidrs = mapped
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("fohuyogdvxkysbxx")
    public suspend fun podCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podCidrs = mapped
    }

    /**
     * @param value ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
     */
    @JvmName("vbitaydkbwbxurff")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("xbyudfoqnoknqkrr")
    public suspend fun serviceCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidrs = mapped
    }

    /**
     * @param values The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("cqwgstssokwfmkod")
    public suspend fun serviceCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceCidrs = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        dnsServiceIP = dnsServiceIP,
        loadBalancerProfile = loadBalancerProfile,
        loadBalancerSku = loadBalancerSku,
        networkPolicy = networkPolicy,
        podCidr = podCidr,
        podCidrs = podCidrs,
        serviceCidr = serviceCidr,
        serviceCidrs = serviceCidrs,
    )
}
