@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * All properties of the provisioned cluster
 * @property aadProfile AAD profile for the provisioned cluster.
 * @property addonProfiles AddonProfiles - Profile of managed cluster add-on.
 * @property agentPoolProfiles The agent pools of the cluster.
 * @property cloudProviderProfile The underlying cloud infra provider properties.
 * @property controlPlane ControlPlane - ControlPlane Configuration
 * @property enableRbac EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
 * @property features Additional features specs like Arc Agent Onboarding.
 * @property httpProxyConfig HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
 * @property kubernetesVersion KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
 * @property linuxProfile LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
 * @property networkProfile NetworkProfile - Profile of network configuration.
 * @property nodeResourceGroup NodeResourceGroup - Name of the resource group containing agent pool nodes.
 * @property windowsProfile WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
 */
public data class ProvisionedClustersAllPropertiesArgs(
    public val aadProfile: Output<AADProfileArgs>? = null,
    public val addonProfiles: Output<Map<String, AddonProfilesArgs>>? = null,
    public val agentPoolProfiles: Output<List<NamedAgentPoolProfileArgs>>? = null,
    public val cloudProviderProfile: Output<CloudProviderProfileArgs>? = null,
    public val controlPlane: Output<ControlPlaneProfileArgs>? = null,
    public val enableRbac: Output<Boolean>? = null,
    public val features: Output<ProvisionedClustersCommonPropertiesFeaturesArgs>? = null,
    public val httpProxyConfig: Output<HttpProxyConfigArgs>? = null,
    public val kubernetesVersion: Output<String>? = null,
    public val linuxProfile: Output<LinuxProfilePropertiesArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val nodeResourceGroup: Output<String>? = null,
    public val windowsProfile: Output<WindowsProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.ProvisionedClustersAllPropertiesArgs.builder()
            .aadProfile(aadProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .addonProfiles(
                addonProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .agentPoolProfiles(
                agentPoolProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudProviderProfile(
                cloudProviderProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .controlPlane(controlPlane?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableRbac(enableRbac?.applyValue({ args0 -> args0 }))
            .features(features?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kubernetesVersion(kubernetesVersion?.applyValue({ args0 -> args0 }))
            .linuxProfile(linuxProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeResourceGroup(nodeResourceGroup?.applyValue({ args0 -> args0 }))
            .windowsProfile(
                windowsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ProvisionedClustersAllPropertiesArgs].
 */
@PulumiTagMarker
public class ProvisionedClustersAllPropertiesArgsBuilder internal constructor() {
    private var aadProfile: Output<AADProfileArgs>? = null

    private var addonProfiles: Output<Map<String, AddonProfilesArgs>>? = null

    private var agentPoolProfiles: Output<List<NamedAgentPoolProfileArgs>>? = null

    private var cloudProviderProfile: Output<CloudProviderProfileArgs>? = null

    private var controlPlane: Output<ControlPlaneProfileArgs>? = null

    private var enableRbac: Output<Boolean>? = null

    private var features: Output<ProvisionedClustersCommonPropertiesFeaturesArgs>? = null

    private var httpProxyConfig: Output<HttpProxyConfigArgs>? = null

    private var kubernetesVersion: Output<String>? = null

    private var linuxProfile: Output<LinuxProfilePropertiesArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var nodeResourceGroup: Output<String>? = null

    private var windowsProfile: Output<WindowsProfileArgs>? = null

    /**
     * @param value AAD profile for the provisioned cluster.
     */
    @JvmName("rhxasasdyndakrxl")
    public suspend fun aadProfile(`value`: Output<AADProfileArgs>) {
        this.aadProfile = value
    }

    /**
     * @param value AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("rmqmxrhmyvviahmp")
    public suspend fun addonProfiles(`value`: Output<Map<String, AddonProfilesArgs>>) {
        this.addonProfiles = value
    }

    /**
     * @param value The agent pools of the cluster.
     */
    @JvmName("dmioualbhaanfgba")
    public suspend fun agentPoolProfiles(`value`: Output<List<NamedAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = value
    }

    @JvmName("pkxyrudlgyhtwhbd")
    public suspend fun agentPoolProfiles(vararg values: Output<NamedAgentPoolProfileArgs>) {
        this.agentPoolProfiles = Output.all(values.asList())
    }

    /**
     * @param values The agent pools of the cluster.
     */
    @JvmName("fqanygluupgophdg")
    public suspend fun agentPoolProfiles(values: List<Output<NamedAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = Output.all(values)
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("sospuualhpobhjps")
    public suspend fun cloudProviderProfile(`value`: Output<CloudProviderProfileArgs>) {
        this.cloudProviderProfile = value
    }

    /**
     * @param value ControlPlane - ControlPlane Configuration
     */
    @JvmName("oeaodupyfhjuqrei")
    public suspend fun controlPlane(`value`: Output<ControlPlaneProfileArgs>) {
        this.controlPlane = value
    }

    /**
     * @param value EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("turwcmretnoxkbxd")
    public suspend fun enableRbac(`value`: Output<Boolean>) {
        this.enableRbac = value
    }

    /**
     * @param value Additional features specs like Arc Agent Onboarding.
     */
    @JvmName("xqybxhmfuuiysrvf")
    public suspend fun features(`value`: Output<ProvisionedClustersCommonPropertiesFeaturesArgs>) {
        this.features = value
    }

    /**
     * @param value HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("hvwejnryytnqllwx")
    public suspend fun httpProxyConfig(`value`: Output<HttpProxyConfigArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
     */
    @JvmName("ngohxphgshxqavfj")
    public suspend fun kubernetesVersion(`value`: Output<String>) {
        this.kubernetesVersion = value
    }

    /**
     * @param value LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
     */
    @JvmName("nyrprebiyqvgkvtj")
    public suspend fun linuxProfile(`value`: Output<LinuxProfilePropertiesArgs>) {
        this.linuxProfile = value
    }

    /**
     * @param value NetworkProfile - Profile of network configuration.
     */
    @JvmName("xpnnnwhmkmsvlhuv")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value NodeResourceGroup - Name of the resource group containing agent pool nodes.
     */
    @JvmName("rqddxpqqiceougvx")
    public suspend fun nodeResourceGroup(`value`: Output<String>) {
        this.nodeResourceGroup = value
    }

    /**
     * @param value WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
     */
    @JvmName("gpnmnrhmrdilhyww")
    public suspend fun windowsProfile(`value`: Output<WindowsProfileArgs>) {
        this.windowsProfile = value
    }

    /**
     * @param value AAD profile for the provisioned cluster.
     */
    @JvmName("fltklbuyrypgbqts")
    public suspend fun aadProfile(`value`: AADProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadProfile = mapped
    }

    /**
     * @param argument AAD profile for the provisioned cluster.
     */
    @JvmName("lwbosxkgwfvbxkyd")
    public suspend fun aadProfile(argument: suspend AADProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AADProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadProfile = mapped
    }

    /**
     * @param value AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("jxpaocblagervdne")
    public suspend fun addonProfiles(`value`: Map<String, AddonProfilesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param argument AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("rmvdqmjuttgftavu")
    public suspend fun addonProfiles(
        vararg
        argument: Pair<String, suspend AddonProfilesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AddonProfilesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.addonProfiles = mapped
    }

    /**
     * @param values AddonProfiles - Profile of managed cluster add-on.
     */
    @JvmName("eodkyjobnybnxjci")
    public fun addonProfiles(vararg values: Pair<String, AddonProfilesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param value The agent pools of the cluster.
     */
    @JvmName("ctwhntypbsahemtc")
    public suspend fun agentPoolProfiles(`value`: List<NamedAgentPoolProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pools of the cluster.
     */
    @JvmName("uetnrappmocpgngo")
    public suspend
    fun agentPoolProfiles(argument: List<suspend NamedAgentPoolProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NamedAgentPoolProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pools of the cluster.
     */
    @JvmName("wwmgoimjdnlojdkd")
    public suspend fun agentPoolProfiles(
        vararg
        argument: suspend NamedAgentPoolProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NamedAgentPoolProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pools of the cluster.
     */
    @JvmName("kmebnohgspbteyfd")
    public suspend
    fun agentPoolProfiles(argument: suspend NamedAgentPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NamedAgentPoolProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param values The agent pools of the cluster.
     */
    @JvmName("fypusyrddaxsmgsg")
    public suspend fun agentPoolProfiles(vararg values: NamedAgentPoolProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param value The underlying cloud infra provider properties.
     */
    @JvmName("gkjqcmbwuqatvdlx")
    public suspend fun cloudProviderProfile(`value`: CloudProviderProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudProviderProfile = mapped
    }

    /**
     * @param argument The underlying cloud infra provider properties.
     */
    @JvmName("axrabjpfubradawn")
    public suspend
    fun cloudProviderProfile(argument: suspend CloudProviderProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudProviderProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudProviderProfile = mapped
    }

    /**
     * @param value ControlPlane - ControlPlane Configuration
     */
    @JvmName("qrassdhexajjynvo")
    public suspend fun controlPlane(`value`: ControlPlaneProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlane = mapped
    }

    /**
     * @param argument ControlPlane - ControlPlane Configuration
     */
    @JvmName("lwvknwxciktjirpj")
    public suspend fun controlPlane(argument: suspend ControlPlaneProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ControlPlaneProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.controlPlane = mapped
    }

    /**
     * @param value EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("yylakdheuodkkqse")
    public suspend fun enableRbac(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRbac = mapped
    }

    /**
     * @param value Additional features specs like Arc Agent Onboarding.
     */
    @JvmName("uisxkwgrynskdljn")
    public suspend fun features(`value`: ProvisionedClustersCommonPropertiesFeaturesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param argument Additional features specs like Arc Agent Onboarding.
     */
    @JvmName("mlgvsxuwqirwiisw")
    public suspend
    fun features(argument: suspend ProvisionedClustersCommonPropertiesFeaturesArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedClustersCommonPropertiesFeaturesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param value HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("ojmgyycliusmamtp")
    public suspend fun httpProxyConfig(`value`: HttpProxyConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("ckgdrksjbjcyhogx")
    public suspend fun httpProxyConfig(argument: suspend HttpProxyConfigArgsBuilder.() -> Unit) {
        val toBeMapped = HttpProxyConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
     */
    @JvmName("iepwqjdhxjalgjui")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
     */
    @JvmName("odxulcaplyurlbmd")
    public suspend fun linuxProfile(`value`: LinuxProfilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxProfile = mapped
    }

    /**
     * @param argument LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
     */
    @JvmName("kufthncaimblmbwq")
    public suspend fun linuxProfile(argument: suspend LinuxProfilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxProfilePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxProfile = mapped
    }

    /**
     * @param value NetworkProfile - Profile of network configuration.
     */
    @JvmName("nvrotwffeuqethhy")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument NetworkProfile - Profile of network configuration.
     */
    @JvmName("njfjgkhwdpbjjdhj")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value NodeResourceGroup - Name of the resource group containing agent pool nodes.
     */
    @JvmName("ffuhwglgojijdase")
    public suspend fun nodeResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeResourceGroup = mapped
    }

    /**
     * @param value WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
     */
    @JvmName("guptialwcewlrfry")
    public suspend fun windowsProfile(`value`: WindowsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsProfile = mapped
    }

    /**
     * @param argument WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
     */
    @JvmName("hnguuobrntofhssu")
    public suspend fun windowsProfile(argument: suspend WindowsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsProfile = mapped
    }

    internal fun build(): ProvisionedClustersAllPropertiesArgs = ProvisionedClustersAllPropertiesArgs(
        aadProfile = aadProfile,
        addonProfiles = addonProfiles,
        agentPoolProfiles = agentPoolProfiles,
        cloudProviderProfile = cloudProviderProfile,
        controlPlane = controlPlane,
        enableRbac = enableRbac,
        features = features,
        httpProxyConfig = httpProxyConfig,
        kubernetesVersion = kubernetesVersion,
        linuxProfile = linuxProfile,
        networkProfile = networkProfile,
        nodeResourceGroup = nodeResourceGroup,
        windowsProfile = windowsProfile,
    )
}
