@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesHciStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mocGroup Resource group in MOC(Microsoft On-premises Cloud)
 * @property mocLocation Location in MOC(Microsoft On-premises Cloud)
 * @property mocStorageContainer Name of the storage container in MOC(Microsoft On-premises Cloud)
 */
public data class StorageSpacesPropertiesHciStorageProfileArgs(
    public val mocGroup: Output<String>? = null,
    public val mocLocation: Output<String>? = null,
    public val mocStorageContainer: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesHciStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesHciStorageProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesHciStorageProfileArgs.builder()
            .mocGroup(mocGroup?.applyValue({ args0 -> args0 }))
            .mocLocation(mocLocation?.applyValue({ args0 -> args0 }))
            .mocStorageContainer(mocStorageContainer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageSpacesPropertiesHciStorageProfileArgs].
 */
@PulumiTagMarker
public class StorageSpacesPropertiesHciStorageProfileArgsBuilder internal constructor() {
    private var mocGroup: Output<String>? = null

    private var mocLocation: Output<String>? = null

    private var mocStorageContainer: Output<String>? = null

    /**
     * @param value Resource group in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("sbqjxiqvygyxwjey")
    public suspend fun mocGroup(`value`: Output<String>) {
        this.mocGroup = value
    }

    /**
     * @param value Location in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("ompwwthjksgkynmc")
    public suspend fun mocLocation(`value`: Output<String>) {
        this.mocLocation = value
    }

    /**
     * @param value Name of the storage container in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("jakcgtwoqslopnrq")
    public suspend fun mocStorageContainer(`value`: Output<String>) {
        this.mocStorageContainer = value
    }

    /**
     * @param value Resource group in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("svksyjancmpbrear")
    public suspend fun mocGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mocGroup = mapped
    }

    /**
     * @param value Location in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("fbrxsbntelelfhte")
    public suspend fun mocLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mocLocation = mapped
    }

    /**
     * @param value Name of the storage container in MOC(Microsoft On-premises Cloud)
     */
    @JvmName("sopneojsntcbjkoa")
    public suspend fun mocStorageContainer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mocStorageContainer = mapped
    }

    internal fun build(): StorageSpacesPropertiesHciStorageProfileArgs =
        StorageSpacesPropertiesHciStorageProfileArgs(
            mocGroup = mocGroup,
            mocLocation = mocLocation,
            mocStorageContainer = mocStorageContainer,
        )
}
