@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksExtendedLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The extended location name.
 * @property type The extended location type.
 */
public data class VirtualNetworksExtendedLocationArgs(
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksExtendedLocationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksExtendedLocationArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksExtendedLocationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworksExtendedLocationArgs].
 */
@PulumiTagMarker
public class VirtualNetworksExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The extended location name.
     */
    @JvmName("aykxjlsegniftxba")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extended location type.
     */
    @JvmName("nmkwmhtxmwsijgcy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The extended location name.
     */
    @JvmName("apnhvoyxgwgpvymv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extended location type.
     */
    @JvmName("qywufvtqtvlygygu")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VirtualNetworksExtendedLocationArgs = VirtualNetworksExtendedLocationArgs(
        name = name,
        type = type,
    )
}
