@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmipPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endIP Ending IP address for the IP Pool
 * @property startIP Starting IP address for the IP Pool
 */
public data class VirtualNetworksPropertiesVmipPoolArgs(
    public val endIP: Output<String>? = null,
    public val startIP: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmipPoolArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmipPoolArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.VirtualNetworksPropertiesVmipPoolArgs.builder()
            .endIP(endIP?.applyValue({ args0 -> args0 }))
            .startIP(startIP?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworksPropertiesVmipPoolArgs].
 */
@PulumiTagMarker
public class VirtualNetworksPropertiesVmipPoolArgsBuilder internal constructor() {
    private var endIP: Output<String>? = null

    private var startIP: Output<String>? = null

    /**
     * @param value Ending IP address for the IP Pool
     */
    @JvmName("anwobtfntlnjxkpi")
    public suspend fun endIP(`value`: Output<String>) {
        this.endIP = value
    }

    /**
     * @param value Starting IP address for the IP Pool
     */
    @JvmName("ixgfukihrdsdbkiy")
    public suspend fun startIP(`value`: Output<String>) {
        this.startIP = value
    }

    /**
     * @param value Ending IP address for the IP Pool
     */
    @JvmName("enqgxkysjmatnkpi")
    public suspend fun endIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIP = mapped
    }

    /**
     * @param value Starting IP address for the IP Pool
     */
    @JvmName("xxujkhvfydpoyxtn")
    public suspend fun startIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIP = mapped
    }

    internal fun build(): VirtualNetworksPropertiesVmipPoolArgs =
        VirtualNetworksPropertiesVmipPoolArgs(
            endIP = endIP,
            startIP = startIP,
        )
}
