@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Addon configurations
 * @property config Config - Key-value pairs for configuring an add-on.
 * @property enabled Enabled - Whether the add-on is enabled or not.
 */
public data class AddonProfilesResponse(
    public val config: Map<String, String>? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.AddonProfilesResponse):
            AddonProfilesResponse = AddonProfilesResponse(
            config = javaType.config().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
