@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the hybridIdentityMetadata.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the provisioned cluster.
 * @property name The name of the resource
 * @property provisioningState provisioning state of the hybridIdentityMetadata resource.
 * @property publicKey Onboarding public key for provisioning the Managed identity for the HybridAKS cluster.
 * @property resourceUid Unique id of the parent provisioned cluster resource.
 * @property systemData The system data.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetHybridIdentityMetadatumResult(
    public val id: String,
    public val identity: ProvisionedClusterIdentityResponse? = null,
    public val name: String,
    public val provisioningState: String,
    public val publicKey: String? = null,
    public val resourceUid: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.GetHybridIdentityMetadatumResult):
            GetHybridIdentityMetadatumResult = GetHybridIdentityMetadatumResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClusterIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicKey = javaType.publicKey().map({ args0 -> args0 }).orElse(null),
            resourceUid = javaType.resourceUid().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
