@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * SSH - SSH configuration for Linux-based VMs running on Azure.
 * @property publicKeys PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
 */
public data class LinuxProfilePropertiesResponseSsh(
    public val publicKeys: List<LinuxProfilePropertiesResponsePublicKeys>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.LinuxProfilePropertiesResponseSsh):
            LinuxProfilePropertiesResponseSsh = LinuxProfilePropertiesResponseSsh(
            publicKeys = javaType.publicKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.LinuxProfilePropertiesResponsePublicKeys.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
