@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
 * @property dhcpServers Address of the DHCP servers associated with the network
 * @property dnsServers Address of the DNS servers associated with the network
 * @property gateway Address of the Gateway associated with the network
 * @property infraVnetProfile
 * @property ipAddressPrefix IP Address Prefix of the network
 * @property provisioningState
 * @property status HybridAKSNetworkStatus defines the observed state of HybridAKSNetwork
 * @property vipPool Virtual IP Pool for Kubernetes
 * @property vlanID VLAN Id used by the network
 * @property vmipPool IP Pool for Virtual Machines
 */
public data class VirtualNetworksPropertiesResponse(
    public val dhcpServers: List<String>,
    public val dnsServers: List<String>? = null,
    public val gateway: String? = null,
    public val infraVnetProfile: VirtualNetworksPropertiesResponseInfraVnetProfile? = null,
    public val ipAddressPrefix: String? = null,
    public val provisioningState: String,
    public val status: VirtualNetworksPropertiesResponseStatus,
    public val vipPool: List<VirtualNetworksPropertiesResponseVipPool>? = null,
    public val vlanID: String,
    public val vmipPool: List<VirtualNetworksPropertiesResponseVmipPool>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.VirtualNetworksPropertiesResponse):
            VirtualNetworksPropertiesResponse = VirtualNetworksPropertiesResponse(
            dhcpServers = javaType.dhcpServers().map({ args0 -> args0 }),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            gateway = javaType.gateway().map({ args0 -> args0 }).orElse(null),
            infraVnetProfile = javaType.infraVnetProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponseInfraVnetProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipAddressPrefix = javaType.ipAddressPrefix().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponseStatus.Companion.toKotlin(args0)
            }),
            vipPool = javaType.vipPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponseVipPool.Companion.toKotlin(args0)
                })
            }),
            vlanID = javaType.vlanID(),
            vmipPool = javaType.vmipPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.VirtualNetworksPropertiesResponseVmipPool.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
