@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin

import com.pulumi.azurenative.hybriddata.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.hybriddata.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DataManager].
 */
@PulumiTagMarker
public class DataManagerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataManagerArgs = DataManagerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataManagerArgsBuilder.() -> Unit) {
        val builder = DataManagerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataManager {
        val builtJavaResource = com.pulumi.azurenative.hybriddata.DataManager(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataManager(builtJavaResource)
    }
}

/**
 * The DataManager resource.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * ## Example Usage
 * ### DataManagers_CreatePUT41
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataManager = new AzureNative.HybridData.DataManager("dataManager", new()
 *     {
 *         DataManagerName = "TestAzureSDKOperations",
 *         Location = "westus",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybriddata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybriddata.NewDataManager(ctx, "dataManager", &hybriddata.DataManagerArgs{
 * 			DataManagerName:   pulumi.String("TestAzureSDKOperations"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybriddata.DataManager;
 * import com.pulumi.azurenative.hybriddata.DataManagerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataManager = new DataManager("dataManager", DataManagerArgs.builder()
 *             .dataManagerName("TestAzureSDKOperations")
 *             .location("westus")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybriddata:DataManager TestAzureSDKOperations /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridData/dataManagers/{dataManagerName}
 * ```
 */
public class DataManager internal constructor(
    override val javaResource: com.pulumi.azurenative.hybriddata.DataManager,
) : KotlinCustomResource(javaResource, DataManagerMapper) {
    /**
     * Etag of the Resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East
     * US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo
     * region is specified on update the request will succeed.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The sku type.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource
     * (across resource groups).
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataManagerMapper : ResourceMapper<DataManager> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybriddata.DataManager::class == javaResource::class

    override fun map(javaResource: Resource): DataManager = DataManager(
        javaResource as
            com.pulumi.azurenative.hybriddata.DataManager,
    )
}

/**
 * @see [DataManager].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataManager].
 */
public suspend fun dataManager(name: String, block: suspend DataManagerResourceBuilder.() -> Unit):
    DataManager {
    val builder = DataManagerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataManager].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataManager(name: String): DataManager {
    val builder = DataManagerResourceBuilder()
    builder.name(name)
    return builder.build()
}
