@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The encryption algorithm used to encrypt data.
 */
public enum class SupportedAlgorithm(
    public val javaValue: com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm> {
    None(com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm.None),
    RSA1_5(com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm.RSA1_5),
    RSA_OAEP(com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm.RSA_OAEP),
    PlainText(com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm.PlainText),
    ;

    override fun toJava(): com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybriddata.enums.SupportedAlgorithm):
            SupportedAlgorithm = SupportedAlgorithm.values().first { it.javaValue == javaType }
    }
}
