@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.inputs

import com.pulumi.azurenative.hybriddata.inputs.CustomerSecretArgs.builder
import com.pulumi.azurenative.hybriddata.kotlin.enums.SupportedAlgorithm
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The pair of customer secret.
 * @property algorithm The encryption algorithm used to encrypt data.
 * @property keyIdentifier The identifier to the data service input object which this secret corresponds to.
 * @property keyValue It contains the encrypted customer secret.
 */
public data class CustomerSecretArgs(
    public val algorithm: Output<SupportedAlgorithm>,
    public val keyIdentifier: Output<String>,
    public val keyValue: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.inputs.CustomerSecretArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.inputs.CustomerSecretArgs =
        com.pulumi.azurenative.hybriddata.inputs.CustomerSecretArgs.builder()
            .algorithm(algorithm.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyIdentifier(keyIdentifier.applyValue({ args0 -> args0 }))
            .keyValue(keyValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerSecretArgs].
 */
@PulumiTagMarker
public class CustomerSecretArgsBuilder internal constructor() {
    private var algorithm: Output<SupportedAlgorithm>? = null

    private var keyIdentifier: Output<String>? = null

    private var keyValue: Output<String>? = null

    /**
     * @param value The encryption algorithm used to encrypt data.
     */
    @JvmName("rleagehrovibdkuf")
    public suspend fun algorithm(`value`: Output<SupportedAlgorithm>) {
        this.algorithm = value
    }

    /**
     * @param value The identifier to the data service input object which this secret corresponds to.
     */
    @JvmName("xymxjogmxmdphpmi")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value It contains the encrypted customer secret.
     */
    @JvmName("frgryavmqipufqvn")
    public suspend fun keyValue(`value`: Output<String>) {
        this.keyValue = value
    }

    /**
     * @param value The encryption algorithm used to encrypt data.
     */
    @JvmName("jvvuykpbjrovhpue")
    public suspend fun algorithm(`value`: SupportedAlgorithm) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value The identifier to the data service input object which this secret corresponds to.
     */
    @JvmName("vteaodednpymjkmq")
    public suspend fun keyIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    /**
     * @param value It contains the encrypted customer secret.
     */
    @JvmName("imvwhcmwpumuxpkj")
    public suspend fun keyValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyValue = mapped
    }

    internal fun build(): CustomerSecretArgs = CustomerSecretArgs(
        algorithm = algorithm ?: throw PulumiNullFieldException("algorithm"),
        keyIdentifier = keyIdentifier ?: throw PulumiNullFieldException("keyIdentifier"),
        keyValue = keyValue ?: throw PulumiNullFieldException("keyValue"),
    )
}
