@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The DataManager resource.
 * @property etag Etag of the Resource.
 * @property id The Resource Id.
 * @property location The location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East
 * US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo
 * region is specified on update the request will succeed.
 * @property name The Resource Name.
 * @property sku The sku type.
 * @property tags The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource
 * (across resource groups).
 * @property type The Resource type.
 */
public data class GetDataManagerResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybriddata.outputs.GetDataManagerResult):
            GetDataManagerResult = GetDataManagerResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybriddata.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
