@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArtifactManifestPropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArtifactManifestPropertiesFormatResponse.Companion.toKotlin as artifactManifestPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ArtifactManifest].
 */
@PulumiTagMarker
public class ArtifactManifestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArtifactManifestArgs = ArtifactManifestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArtifactManifestArgsBuilder.() -> Unit) {
        val builder = ArtifactManifestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ArtifactManifest {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.ArtifactManifest(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ArtifactManifest(builtJavaResource)
    }
}

/**
 * Artifact manifest properties.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update the artifact manifest resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactManifest = new AzureNative.HybridNetwork.ArtifactManifest("artifactManifest", new()
 *     {
 *         ArtifactManifestName = "TestManifest",
 *         ArtifactStoreName = "TestArtifactStore",
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ArtifactManifestPropertiesFormatArgs
 *         {
 *             Artifacts = new[]
 *             {
 *                 new AzureNative.HybridNetwork.Inputs.ManifestArtifactFormatArgs
 *                 {
 *                     ArtifactName = "fed-rbac",
 *                     ArtifactType = AzureNative.HybridNetwork.ArtifactType.OCIArtifact,
 *                     ArtifactVersion = "1.0.0",
 *                 },
 *                 new AzureNative.HybridNetwork.Inputs.ManifestArtifactFormatArgs
 *                 {
 *                     ArtifactName = "nginx",
 *                     ArtifactType = AzureNative.HybridNetwork.ArtifactType.OCIArtifact,
 *                     ArtifactVersion = "v1",
 *                 },
 *             },
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewArtifactManifest(ctx, "artifactManifest", &hybridnetwork.ArtifactManifestArgs{
 * 			ArtifactManifestName: pulumi.String("TestManifest"),
 * 			ArtifactStoreName:    pulumi.String("TestArtifactStore"),
 * 			Location:             pulumi.String("eastus"),
 * 			Properties: &hybridnetwork.ArtifactManifestPropertiesFormatArgs{
 * 				Artifacts: hybridnetwork.ManifestArtifactFormatArray{
 * 					&hybridnetwork.ManifestArtifactFormatArgs{
 * 						ArtifactName:    pulumi.String("fed-rbac"),
 * 						ArtifactType:    pulumi.String(hybridnetwork.ArtifactTypeOCIArtifact),
 * 						ArtifactVersion: pulumi.String("1.0.0"),
 * 					},
 * 					&hybridnetwork.ManifestArtifactFormatArgs{
 * 						ArtifactName:    pulumi.String("nginx"),
 * 						ArtifactType:    pulumi.String(hybridnetwork.ArtifactTypeOCIArtifact),
 * 						ArtifactVersion: pulumi.String("v1"),
 * 					},
 * 				},
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactManifest;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactManifestArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.ArtifactManifestPropertiesFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactManifest = new ArtifactManifest("artifactManifest", ArtifactManifestArgs.builder()
 *             .artifactManifestName("TestManifest")
 *             .artifactStoreName("TestArtifactStore")
 *             .location("eastus")
 *             .properties(ArtifactManifestPropertiesFormatArgs.builder()
 *                 .artifacts(
 *                     ManifestArtifactFormatArgs.builder()
 *                         .artifactName("fed-rbac")
 *                         .artifactType("OCIArtifact")
 *                         .artifactVersion("1.0.0")
 *                         .build(),
 *                     ManifestArtifactFormatArgs.builder()
 *                         .artifactName("nginx")
 *                         .artifactType("OCIArtifact")
 *                         .artifactVersion("v1")
 *                         .build())
 *                 .build())
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:ArtifactManifest TestManifest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}
 * ```
 */
public class ArtifactManifest internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.ArtifactManifest,
) : KotlinCustomResource(javaResource, ArtifactManifestMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Artifact manifest properties.
     */
    public val properties: Output<ArtifactManifestPropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                artifactManifestPropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ArtifactManifestMapper : ResourceMapper<ArtifactManifest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.ArtifactManifest::class == javaResource::class

    override fun map(javaResource: Resource): ArtifactManifest = ArtifactManifest(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.ArtifactManifest,
    )
}

/**
 * @see [ArtifactManifest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArtifactManifest].
 */
public suspend fun artifactManifest(
    name: String,
    block: suspend ArtifactManifestResourceBuilder.() -> Unit,
): ArtifactManifest {
    val builder = ArtifactManifestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArtifactManifest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun artifactManifest(name: String): ArtifactManifest {
    val builder = ArtifactManifestResourceBuilder()
    builder.name(name)
    return builder.build()
}
