@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ContainerizedNetworkFunctionDefinitionVersionArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Network function definition version.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update a network function definition version resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionVersion = new AzureNative.HybridNetwork.NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         NetworkFunctionDefinitionVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ContainerizedNetworkFunctionDefinitionVersionArgs
 *         {
 *             DeployParameters = "{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}",
 *             NetworkFunctionTemplate = new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesNetworkFunctionTemplateArgs
 *             {
 *                 NetworkFunctionApplications = new[]
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesHelmApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore",
 *                             },
 *                             HelmArtifactProfile = new AzureNative.HybridNetwork.Inputs.HelmArtifactProfileArgs
 *                             {
 *                                 HelmPackageName = "fed-rbac",
 *                                 HelmPackageVersionRange = "~2.1.3",
 *                                 ImagePullSecretsValuesPaths = new[]
 *                                 {
 *                                     "global.imagePullSecrets",
 *                                 },
 *                                 RegistryValuesPaths = new[]
 *                                 {
 *                                     "global.registry.docker.repoPath",
 *                                 },
 *                             },
 *                         },
 *                         ArtifactType = "HelmPackage",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new() { },
 *                             UninstallDependsOn = new() { },
 *                             UpdateDependsOn = new() { },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureArcKubernetesDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = AzureNative.HybridNetwork.ApplicationEnablement.Enabled,
 *                             HelmMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.HelmMappingRuleProfileArgs
 *                             {
 *                                 HelmPackageVersion = "2.1.3",
 *                                 Options = new AzureNative.HybridNetwork.Inputs.HelmMappingRuleProfileOptionsArgs
 *                                 {
 *                                     InstallOptions = new AzureNative.HybridNetwork.Inputs.HelmInstallOptionsArgs
 *                                     {
 *                                         Atomic = "true",
 *                                         Timeout = "30",
 *                                         Wait = "waitValue",
 *                                     },
 *                                     UpgradeOptions = new AzureNative.HybridNetwork.Inputs.HelmUpgradeOptionsArgs
 *                                     {
 *                                         Atomic = "true",
 *                                         Timeout = "30",
 *                                         Wait = "waitValue",
 *                                     },
 *                                 },
 *                                 ReleaseName = "{deployParameters.releaseName}",
 *                                 ReleaseNamespace = "{deployParameters.namesapce}",
 *                                 Values = "",
 *                             },
 *                         },
 *                         Name = "fedrbac",
 *                     },
 *                 },
 *                 NfviType = "AzureArcKubernetes",
 *             },
 *             NetworkFunctionType = "ContainerizedNetworkFunction",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionVersion(ctx, "networkFunctionDefinitionVersion", &hybridnetwork.NetworkFunctionDefinitionVersionArgs{
 * 			Location:                             pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName:   pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			NetworkFunctionDefinitionVersionName: pulumi.String("1.0.0"),
 * 			Properties: hybridnetwork.ContainerizedNetworkFunctionDefinitionVersion{
 * 				DeployParameters: "{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}",
 * 				NetworkFunctionTemplate: hybridnetwork.AzureArcKubernetesNetworkFunctionTemplate{
 * 					NetworkFunctionApplications: []hybridnetwork.AzureArcKubernetesHelmApplication{
 * 						{
 * 							ArtifactProfile: {
 * 								ArtifactStore: {
 * 									Id: "/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore",
 * 								},
 * 								HelmArtifactProfile: {
 * 									HelmPackageName:         "fed-rbac",
 * 									HelmPackageVersionRange: "~2.1.3",
 * 									ImagePullSecretsValuesPaths: []string{
 * 										"global.imagePullSecrets",
 * 									},
 * 									RegistryValuesPaths: []string{
 * 										"global.registry.docker.repoPath",
 * 									},
 * 								},
 * 							},
 * 							ArtifactType: "HelmPackage",
 * 							DependsOnProfile: {
 * 								InstallDependsOn:   []interface{}{},
 * 								UninstallDependsOn: []interface{}{},
 * 								UpdateDependsOn:    []interface{}{},
 * 							},
 * 							DeployParametersMappingRuleProfile: {
 * 								ApplicationEnablement: hybridnetwork.ApplicationEnablementEnabled,
 * 								HelmMappingRuleProfile: {
 * 									HelmPackageVersion: "2.1.3",
 * 									Options: {
 * 										InstallOptions: {
 * 											Atomic:  "true",
 * 											Timeout: "30",
 * 											Wait:    "waitValue",
 * 										},
 * 										UpgradeOptions: {
 * 											Atomic:  "true",
 * 											Timeout: "30",
 * 											Wait:    "waitValue",
 * 										},
 * 									},
 * 									ReleaseName:      "{deployParameters.releaseName}",
 * 									ReleaseNamespace: "{deployParameters.namesapce}",
 * 									Values:           "",
 * 								},
 * 							},
 * 							Name: "fedrbac",
 * 						},
 * 					},
 * 					NfviType: "AzureArcKubernetes",
 * 				},
 * 				NetworkFunctionType: "ContainerizedNetworkFunction",
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionVersion = new NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", NetworkFunctionDefinitionVersionArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .networkFunctionDefinitionVersionName("1.0.0")
 *             .properties(ContainerizedNetworkFunctionDefinitionVersionArgs.builder()
 *                 .deployParameters("{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}")
 *                 .networkFunctionTemplate(AzureArcKubernetesNetworkFunctionTemplateArgs.builder()
 *                     .networkFunctionApplications(AzureArcKubernetesHelmApplicationArgs.builder()
 *                         .artifactProfile(AzureArcKubernetesArtifactProfileArgs.builder()
 *                             .artifactStore(ReferencedResourceArgs.builder()
 *                                 .id("/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore")
 *                                 .build())
 *                             .helmArtifactProfile(HelmArtifactProfileArgs.builder()
 *                                 .helmPackageName("fed-rbac")
 *                                 .helmPackageVersionRange("~2.1.3")
 *                                 .imagePullSecretsValuesPaths("global.imagePullSecrets")
 *                                 .registryValuesPaths("global.registry.docker.repoPath")
 *                                 .build())
 *                             .build())
 *                         .artifactType("HelmPackage")
 *                         .dependsOnProfile(DependsOnProfileArgs.builder()
 *                             .installDependsOn()
 *                             .uninstallDependsOn()
 *                             .updateDependsOn()
 *                             .build())
 *                         .deployParametersMappingRuleProfile(AzureArcKubernetesDeployMappingRuleProfileArgs.builder()
 *                             .applicationEnablement("Enabled")
 *                             .helmMappingRuleProfile(HelmMappingRuleProfileArgs.builder()
 *                                 .helmPackageVersion("2.1.3")
 *                                 .options(HelmMappingRuleProfileOptionsArgs.builder()
 *                                     .installOptions(HelmInstallOptionsArgs.builder()
 *                                         .atomic("true")
 *                                         .timeout("30")
 *                                         .wait("waitValue")
 *                                         .build())
 *                                     .upgradeOptions(HelmUpgradeOptionsArgs.builder()
 *                                         .atomic("true")
 *                                         .timeout("30")
 *                                         .wait("waitValue")
 *                                         .build())
 *                                     .build())
 *                                 .releaseName("{deployParameters.releaseName}")
 *                                 .releaseNamespace("{deployParameters.namesapce}")
 *                                 .values("")
 *                                 .build())
 *                             .build())
 *                         .name("fedrbac")
 *                         .build())
 *                     .nfviType("AzureArcKubernetes")
 *                     .build())
 *                 .networkFunctionType("ContainerizedNetworkFunction")
 *                 .build())
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a network function definition version resource for AzureCore VNF
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionVersion = new AzureNative.HybridNetwork.NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         NetworkFunctionDefinitionVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs
 *         {
 *             DeployParameters = "{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 *             Description = "test NFDV for AzureCore",
 *             NetworkFunctionTemplate = new AzureNative.HybridNetwork.Inputs.AzureCoreNetworkFunctionTemplateArgs
 *             {
 *                 NetworkFunctionApplications =
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.AzureCoreNetworkFunctionVhdApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreVhdImageArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             VhdArtifactProfile = new AzureNative.HybridNetwork.Inputs.VhdImageArtifactProfileArgs
 *                             {
 *                                 VhdName = "test-image",
 *                                 VhdVersion = "1-0-0",
 *                             },
 *                         },
 *                         ArtifactType = "VhdImageFile",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new() { },
 *                             UninstallDependsOn = new() { },
 *                             UpdateDependsOn = new() { },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreVhdImageDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = AzureNative.HybridNetwork.ApplicationEnablement.Unknown,
 *                             VhdImageMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.VhdImageMappingRuleProfileArgs
 *                             {
 *                                 UserConfiguration = "",
 *                             },
 *                         },
 *                         Name = "testImageRole",
 *                     },
 *                     new AzureNative.HybridNetwork.Inputs.AzureCoreNetworkFunctionArmTemplateApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreArmTemplateArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             TemplateArtifactProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateArtifactProfileArgs
 *                             {
 *                                 TemplateName = "test-template",
 *                                 TemplateVersion = "1.0.0",
 *                             },
 *                         },
 *                         ArtifactType = "ArmTemplate",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UninstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UpdateDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureCoreArmTemplateDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = AzureNative.HybridNetwork.ApplicationEnablement.Unknown,
 *                             TemplateMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateMappingRuleProfileArgs
 *                             {
 *                                 TemplateParameters = "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 *                             },
 *                         },
 *                         Name = "testTemplateRole",
 *                     },
 *                 },
 *                 NfviType = "AzureCore",
 *             },
 *             NetworkFunctionType = "VirtualNetworkFunction",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionVersion(ctx, "networkFunctionDefinitionVersion", &hybridnetwork.NetworkFunctionDefinitionVersionArgs{
 * 			Location:                             pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName:   pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			NetworkFunctionDefinitionVersionName: pulumi.String("1.0.0"),
 * 			Properties: hybridnetwork.VirtualNetworkFunctionNetworkFunctionDefinitionVersion{
 * 				DeployParameters: "{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 * 				Description:      "test NFDV for AzureCore",
 * 				NetworkFunctionTemplate: hybridnetwork.AzureCoreNetworkFunctionTemplate{
 * 					NetworkFunctionApplications: []interface{}{
 * 						hybridnetwork.AzureCoreNetworkFunctionVhdApplication{
 * 							ArtifactProfile: hybridnetwork.AzureCoreVhdImageArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								VhdArtifactProfile: hybridnetwork.VhdImageArtifactProfile{
 * 									VhdName:    "test-image",
 * 									VhdVersion: "1-0-0",
 * 								},
 * 							},
 * 							ArtifactType: "VhdImageFile",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn:   []interface{}{},
 * 								UninstallDependsOn: []interface{}{},
 * 								UpdateDependsOn:    []interface{}{},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureCoreVhdImageDeployMappingRuleProfile{
 * 								ApplicationEnablement: hybridnetwork.ApplicationEnablementUnknown,
 * 								VhdImageMappingRuleProfile: hybridnetwork.VhdImageMappingRuleProfile{
 * 									UserConfiguration: "",
 * 								},
 * 							},
 * 							Name: "testImageRole",
 * 						},
 * 						hybridnetwork.AzureCoreNetworkFunctionArmTemplateApplication{
 * 							ArtifactProfile: hybridnetwork.AzureCoreArmTemplateArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								TemplateArtifactProfile: hybridnetwork.ArmTemplateArtifactProfile{
 * 									TemplateName:    "test-template",
 * 									TemplateVersion: "1.0.0",
 * 								},
 * 							},
 * 							ArtifactType: "ArmTemplate",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UninstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UpdateDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureCoreArmTemplateDeployMappingRuleProfile{
 * 								ApplicationEnablement: hybridnetwork.ApplicationEnablementUnknown,
 * 								TemplateMappingRuleProfile: hybridnetwork.ArmTemplateMappingRuleProfile{
 * 									TemplateParameters: "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 * 								},
 * 							},
 * 							Name: "testTemplateRole",
 * 						},
 * 					},
 * 					NfviType: "AzureCore",
 * 				},
 * 				NetworkFunctionType: "VirtualNetworkFunction",
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionVersion = new NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", NetworkFunctionDefinitionVersionArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .networkFunctionDefinitionVersionName("1.0.0")
 *             .properties(VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs.builder()
 *                 .deployParameters("{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}")
 *                 .description("test NFDV for AzureCore")
 *                 .networkFunctionTemplate(AzureCoreNetworkFunctionTemplateArgs.builder()
 *                     .networkFunctionApplications(
 *                         AzureCoreNetworkFunctionArmTemplateApplicationArgs.builder()
 *                             .artifactProfile(AzureCoreArmTemplateArtifactProfileArgs.builder()
 *                                 .artifactStore(ReferencedResourceArgs.builder()
 *                                     .id("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")
 *                                     .build())
 *                                 .vhdArtifactProfile(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                                 .build())
 *                             .artifactType("VhdImageFile")
 *                             .dependsOnProfile(DependsOnProfileArgs.builder()
 *                                 .installDependsOn()
 *                                 .uninstallDependsOn()
 *                                 .updateDependsOn()
 *                                 .build())
 *                             .deployParametersMappingRuleProfile(AzureCoreArmTemplateDeployMappingRuleProfileArgs.builder()
 *                                 .applicationEnablement("Unknown")
 *                                 .vhdImageMappingRuleProfile(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                                 .build())
 *                             .name("testImageRole")
 *                             .build(),
 *                         AzureCoreNetworkFunctionArmTemplateApplicationArgs.builder()
 *                             .artifactProfile(AzureCoreArmTemplateArtifactProfileArgs.builder()
 *                                 .artifactStore(ReferencedResourceArgs.builder()
 *                                     .id("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")
 *                                     .build())
 *                                 .templateArtifactProfile(ArmTemplateArtifactProfileArgs.builder()
 *                                     .templateName("test-template")
 *                                     .templateVersion("1.0.0")
 *                                     .build())
 *                                 .build())
 *                             .artifactType("ArmTemplate")
 *                             .dependsOnProfile(DependsOnProfileArgs.builder()
 *                                 .installDependsOn("testImageRole")
 *                                 .uninstallDependsOn("testImageRole")
 *                                 .updateDependsOn("testImageRole")
 *                                 .build())
 *                             .deployParametersMappingRuleProfile(AzureCoreArmTemplateDeployMappingRuleProfileArgs.builder()
 *                                 .applicationEnablement("Unknown")
 *                                 .templateMappingRuleProfile(ArmTemplateMappingRuleProfileArgs.builder()
 *                                     .templateParameters("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}")
 *                                     .build())
 *                                 .build())
 *                             .name("testTemplateRole")
 *                             .build())
 *                     .nfviType("AzureCore")
 *                     .build())
 *                 .networkFunctionType("VirtualNetworkFunction")
 *                 .build())
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a network function definition version resource for AzureOperatorNexus VNF
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionVersion = new AzureNative.HybridNetwork.NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         NetworkFunctionDefinitionVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs
 *         {
 *             DeployParameters = "{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 *             Description = "test NFDV for AzureOperatorNexus",
 *             NetworkFunctionTemplate = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusNetworkFunctionTemplateArgs
 *             {
 *                 NetworkFunctionApplications =
 *                 {
 *                     new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusNetworkFunctionImageApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusImageArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             ImageArtifactProfile = new AzureNative.HybridNetwork.Inputs.ImageArtifactProfileArgs
 *                             {
 *                                 ImageName = "test-image",
 *                                 ImageVersion = "1.0.0",
 *                             },
 *                         },
 *                         ArtifactType = "ImageFile",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new() { },
 *                             UninstallDependsOn = new() { },
 *                             UpdateDependsOn = new() { },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusImageDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = AzureNative.HybridNetwork.ApplicationEnablement.Unknown,
 *                             ImageMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.ImageMappingRuleProfileArgs
 *                             {
 *                                 UserConfiguration = "",
 *                             },
 *                         },
 *                         Name = "testImageRole",
 *                     },
 *                     new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusArmTemplateArtifactProfileArgs
 *                         {
 *                             ArtifactStore = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 *                             },
 *                             TemplateArtifactProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateArtifactProfileArgs
 *                             {
 *                                 TemplateName = "test-template",
 *                                 TemplateVersion = "1.0.0",
 *                             },
 *                         },
 *                         ArtifactType = "ArmTemplate",
 *                         DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                         {
 *                             InstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UninstallDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                             UpdateDependsOn = new[]
 *                             {
 *                                 "testImageRole",
 *                             },
 *                         },
 *                         DeployParametersMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs
 *                         {
 *                             ApplicationEnablement = AzureNative.HybridNetwork.ApplicationEnablement.Unknown,
 *                             TemplateMappingRuleProfile = new AzureNative.HybridNetwork.Inputs.ArmTemplateMappingRuleProfileArgs
 *                             {
 *                                 TemplateParameters = "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 *                             },
 *                         },
 *                         Name = "testTemplateRole",
 *                     },
 *                 },
 *                 NfviType = "AzureOperatorNexus",
 *             },
 *             NetworkFunctionType = "VirtualNetworkFunction",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionVersion(ctx, "networkFunctionDefinitionVersion", &hybridnetwork.NetworkFunctionDefinitionVersionArgs{
 * 			Location:                             pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName:   pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			NetworkFunctionDefinitionVersionName: pulumi.String("1.0.0"),
 * 			Properties: hybridnetwork.VirtualNetworkFunctionNetworkFunctionDefinitionVersion{
 * 				DeployParameters: "{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}",
 * 				Description:      "test NFDV for AzureOperatorNexus",
 * 				NetworkFunctionTemplate: hybridnetwork.AzureOperatorNexusNetworkFunctionTemplate{
 * 					NetworkFunctionApplications: []interface{}{
 * 						hybridnetwork.AzureOperatorNexusNetworkFunctionImageApplication{
 * 							ArtifactProfile: hybridnetwork.AzureOperatorNexusImageArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								ImageArtifactProfile: hybridnetwork.ImageArtifactProfile{
 * 									ImageName:    "test-image",
 * 									ImageVersion: "1.0.0",
 * 								},
 * 							},
 * 							ArtifactType: "ImageFile",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn:   []interface{}{},
 * 								UninstallDependsOn: []interface{}{},
 * 								UpdateDependsOn:    []interface{}{},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureOperatorNexusImageDeployMappingRuleProfile{
 * 								ApplicationEnablement: hybridnetwork.ApplicationEnablementUnknown,
 * 								ImageMappingRuleProfile: hybridnetwork.ImageMappingRuleProfile{
 * 									UserConfiguration: "",
 * 								},
 * 							},
 * 							Name: "testImageRole",
 * 						},
 * 						hybridnetwork.AzureOperatorNexusNetworkFunctionArmTemplateApplication{
 * 							ArtifactProfile: hybridnetwork.AzureOperatorNexusArmTemplateArtifactProfile{
 * 								ArtifactStore: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore",
 * 								},
 * 								TemplateArtifactProfile: hybridnetwork.ArmTemplateArtifactProfile{
 * 									TemplateName:    "test-template",
 * 									TemplateVersion: "1.0.0",
 * 								},
 * 							},
 * 							ArtifactType: "ArmTemplate",
 * 							DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 								InstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UninstallDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 								UpdateDependsOn: []string{
 * 									"testImageRole",
 * 								},
 * 							},
 * 							DeployParametersMappingRuleProfile: hybridnetwork.AzureOperatorNexusArmTemplateDeployMappingRuleProfile{
 * 								ApplicationEnablement: hybridnetwork.ApplicationEnablementUnknown,
 * 								TemplateMappingRuleProfile: hybridnetwork.ArmTemplateMappingRuleProfile{
 * 									TemplateParameters: "{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}",
 * 								},
 * 							},
 * 							Name: "testTemplateRole",
 * 						},
 * 					},
 * 					NfviType: "AzureOperatorNexus",
 * 				},
 * 				NetworkFunctionType: "VirtualNetworkFunction",
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionVersion = new NetworkFunctionDefinitionVersion("networkFunctionDefinitionVersion", NetworkFunctionDefinitionVersionArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .networkFunctionDefinitionVersionName("1.0.0")
 *             .properties(VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs.builder()
 *                 .deployParameters("{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}")
 *                 .description("test NFDV for AzureOperatorNexus")
 *                 .networkFunctionTemplate(AzureOperatorNexusNetworkFunctionTemplateArgs.builder()
 *                     .networkFunctionApplications(
 *                         AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs.builder()
 *                             .artifactProfile(AzureOperatorNexusArmTemplateArtifactProfileArgs.builder()
 *                                 .artifactStore(ReferencedResourceArgs.builder()
 *                                     .id("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")
 *                                     .build())
 *                                 .imageArtifactProfile(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                                 .build())
 *                             .artifactType("ImageFile")
 *                             .dependsOnProfile(DependsOnProfileArgs.builder()
 *                                 .installDependsOn()
 *                                 .uninstallDependsOn()
 *                                 .updateDependsOn()
 *                                 .build())
 *                             .deployParametersMappingRuleProfile(AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs.builder()
 *                                 .applicationEnablement("Unknown")
 *                                 .imageMappingRuleProfile(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                                 .build())
 *                             .name("testImageRole")
 *                             .build(),
 *                         AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs.builder()
 *                             .artifactProfile(AzureOperatorNexusArmTemplateArtifactProfileArgs.builder()
 *                                 .artifactStore(ReferencedResourceArgs.builder()
 *                                     .id("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore")
 *                                     .build())
 *                                 .templateArtifactProfile(ArmTemplateArtifactProfileArgs.builder()
 *                                     .templateName("test-template")
 *                                     .templateVersion("1.0.0")
 *                                     .build())
 *                                 .build())
 *                             .artifactType("ArmTemplate")
 *                             .dependsOnProfile(DependsOnProfileArgs.builder()
 *                                 .installDependsOn("testImageRole")
 *                                 .uninstallDependsOn("testImageRole")
 *                                 .updateDependsOn("testImageRole")
 *                                 .build())
 *                             .deployParametersMappingRuleProfile(AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs.builder()
 *                                 .applicationEnablement("Unknown")
 *                                 .templateMappingRuleProfile(ArmTemplateMappingRuleProfileArgs.builder()
 *                                     .templateParameters("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}")
 *                                     .build())
 *                                 .build())
 *                             .name("testTemplateRole")
 *                             .build())
 *                     .nfviType("AzureOperatorNexus")
 *                     .build())
 *                 .networkFunctionType("VirtualNetworkFunction")
 *                 .build())
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkFunctionDefinitionVersion TestVersion /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/networkFunctionDefinitionGroups/{networkFunctionDefinitionGroupName}/networkFunctionDefinitionVersions/{networkFunctionDefinitionVersionName}
 * ```
 * @property location The geo-location where the resource lives
 * @property networkFunctionDefinitionGroupName The name of the network function definition group.
 * @property networkFunctionDefinitionVersionName The name of the network function definition version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
 * @property properties Network function definition version properties.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkFunctionDefinitionVersionArgs(
    public val location: Output<String>? = null,
    public val networkFunctionDefinitionGroupName: Output<String>? = null,
    public val networkFunctionDefinitionVersionName: Output<String>? = null,
    public val properties:
    Output<Either<ContainerizedNetworkFunctionDefinitionVersionArgs, VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs>>? =
        null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs =
        com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionVersionArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFunctionDefinitionGroupName(
                networkFunctionDefinitionGroupName?.applyValue({ args0 ->
                    args0
                }),
            )
            .networkFunctionDefinitionVersionName(
                networkFunctionDefinitionVersionName?.applyValue({ args0 ->
                    args0
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkFunctionDefinitionVersionArgs].
 */
@PulumiTagMarker
public class NetworkFunctionDefinitionVersionArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var networkFunctionDefinitionGroupName: Output<String>? = null

    private var networkFunctionDefinitionVersionName: Output<String>? = null

    private var properties:
        Output<Either<ContainerizedNetworkFunctionDefinitionVersionArgs, VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs>>? =
        null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("knguvcjoarbogvms")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network function definition group.
     */
    @JvmName("ngibppyhsjwvhlhy")
    public suspend fun networkFunctionDefinitionGroupName(`value`: Output<String>) {
        this.networkFunctionDefinitionGroupName = value
    }

    /**
     * @param value The name of the network function definition version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     */
    @JvmName("ucxxtblqselhwigd")
    public suspend fun networkFunctionDefinitionVersionName(`value`: Output<String>) {
        this.networkFunctionDefinitionVersionName = value
    }

    /**
     * @param value Network function definition version properties.
     */
    @JvmName("wmamxygwohunpvue")
    public suspend
    fun properties(`value`: Output<Either<ContainerizedNetworkFunctionDefinitionVersionArgs, VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("hhifwmdliqexfcxa")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mbwjntgdpbuynikj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("waymriudgfhthkbs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("occmpkarsecocrtx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network function definition group.
     */
    @JvmName("bqcyfebqcsirtcqa")
    public suspend fun networkFunctionDefinitionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionDefinitionGroupName = mapped
    }

    /**
     * @param value The name of the network function definition version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     */
    @JvmName("pkgurrxiwvougwsa")
    public suspend fun networkFunctionDefinitionVersionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionDefinitionVersionName = mapped
    }

    /**
     * @param value Network function definition version properties.
     */
    @JvmName("ceunnihxsxppufen")
    public suspend
    fun properties(`value`: Either<ContainerizedNetworkFunctionDefinitionVersionArgs, VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Network function definition version properties.
     */
    @JvmName("nfuxxmkgfflcehgn")
    public fun properties(`value`: ContainerizedNetworkFunctionDefinitionVersionArgs) {
        val toBeMapped = Either.ofLeft<ContainerizedNetworkFunctionDefinitionVersionArgs,
            VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Network function definition version properties.
     */
    @JvmName("nfswedjdxxpuqeww")
    public fun properties(`value`: VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs) {
        val toBeMapped = Either.ofRight<ContainerizedNetworkFunctionDefinitionVersionArgs,
            VirtualNetworkFunctionNetworkFunctionDefinitionVersionArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("vvlyqqoctljvsfky")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hnupmdehbelrscov")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("frpysqwjtdrpkjsa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hteafgtudgchhmlk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkFunctionDefinitionVersionArgs = NetworkFunctionDefinitionVersionArgs(
        location = location,
        networkFunctionDefinitionGroupName = networkFunctionDefinitionGroupName,
        networkFunctionDefinitionVersionName = networkFunctionDefinitionVersionName,
        properties = properties,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
