@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkServiceDesignVersionPropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkServiceDesignVersionPropertiesFormatResponse.Companion.toKotlin as networkServiceDesignVersionPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkServiceDesignVersion].
 */
@PulumiTagMarker
public class NetworkServiceDesignVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkServiceDesignVersionArgs = NetworkServiceDesignVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkServiceDesignVersionArgsBuilder.() -> Unit) {
        val builder = NetworkServiceDesignVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkServiceDesignVersion {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkServiceDesignVersion(builtJavaResource)
    }
}

/**
 * network service design version.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update a network service design version resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkServiceDesignVersion = new AzureNative.HybridNetwork.NetworkServiceDesignVersion("networkServiceDesignVersion", new()
 *     {
 *         Location = "eastus",
 *         NetworkServiceDesignGroupName = "TestNetworkServiceDesignGroupName",
 *         NetworkServiceDesignVersionName = "1.0.0",
 *         Properties = new AzureNative.HybridNetwork.Inputs.NetworkServiceDesignVersionPropertiesFormatArgs
 *         {
 *             ConfigurationGroupSchemaReferences =
 *             {
 *                 { "MyVM_Configuration", new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/publishers/contosoGroup/networkServiceDesignGroups/NSD_contoso/configurationGroupSchemas/MyVM_Configuration_Schema",
 *                 } },
 *             },
 *             ResourceElementTemplates = new[]
 *             {
 *                 new AzureNative.HybridNetwork.Inputs.ArmResourceDefinitionResourceElementTemplateDetailsArgs
 *                 {
 *                     Configuration = new AzureNative.HybridNetwork.Inputs.ArmResourceDefinitionResourceElementTemplateArgs
 *                     {
 *                         ArtifactProfile = new AzureNative.HybridNetwork.Inputs.NSDArtifactProfileArgs
 *                         {
 *                             ArtifactName = "MyVMArmTemplate",
 *                             ArtifactStoreReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/providers/Microsoft.HybridNetwork/publishers/contosoGroup/artifactStoreReference/store1",
 *                             },
 *                             ArtifactVersion = "1.0.0",
 *                         },
 *                         ParameterValues = "{\"publisherName\":\"{configurationparameters('MyVM_Configuration').publisherName}\",\"skuGroupName\":\"{configurationparameters('MyVM_Configuration').skuGroupName}\",\"skuVersion\":\"{configurationparameters('MyVM_Configuration').skuVersion}\",\"skuOfferingLocation\":\"{configurationparameters('MyVM_Configuration').skuOfferingLocation}\",\"nfviType\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviType}\",\"nfviId\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviId}\",\"allowSoftwareUpdates\":\"{configurationparameters('MyVM_Configuration').allowSoftwareUpdates}\",\"virtualNetworkName\":\"{configurationparameters('MyVM_Configuration').vnetName}\",\"subnetName\":\"{configurationparameters('MyVM_Configuration').subnetName}\",\"subnetAddressPrefix\":\"{configurationparameters('MyVM_Configuration').subnetAddressPrefix}\",\"managedResourceGroup\":\"{configurationparameters('SNSSelf').managedResourceGroupName}\",\"adminPassword\":\"{secretparameters('MyVM_Configuration').adminPassword}\"}",
 *                         TemplateType = AzureNative.HybridNetwork.TemplateType.ArmTemplate,
 *                     },
 *                     DependsOnProfile = new AzureNative.HybridNetwork.Inputs.DependsOnProfileArgs
 *                     {
 *                         InstallDependsOn = new() { },
 *                     },
 *                     Name = "MyVM",
 *                     ResourceElementType = "ArmResourceDefinition",
 *                 },
 *             },
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkServiceDesignVersion(ctx, "networkServiceDesignVersion", &hybridnetwork.NetworkServiceDesignVersionArgs{
 * 			Location:                        pulumi.String("eastus"),
 * 			NetworkServiceDesignGroupName:   pulumi.String("TestNetworkServiceDesignGroupName"),
 * 			NetworkServiceDesignVersionName: pulumi.String("1.0.0"),
 * 			Properties: &hybridnetwork.NetworkServiceDesignVersionPropertiesFormatArgs{
 * 				ConfigurationGroupSchemaReferences: hybridnetwork.ReferencedResourceMap{
 * 					"MyVM_Configuration": &hybridnetwork.ReferencedResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/publishers/contosoGroup/networkServiceDesignGroups/NSD_contoso/configurationGroupSchemas/MyVM_Configuration_Schema"),
 * 					},
 * 				},
 * 				ResourceElementTemplates: pulumi.Array{
 * 					hybridnetwork.ArmResourceDefinitionResourceElementTemplateDetails{
 * 						Configuration: hybridnetwork.ArmResourceDefinitionResourceElementTemplate{
 * 							ArtifactProfile: hybridnetwork.NSDArtifactProfile{
 * 								ArtifactName: "MyVMArmTemplate",
 * 								ArtifactStoreReference: hybridnetwork.ReferencedResource{
 * 									Id: "/subscriptions/subid/providers/Microsoft.HybridNetwork/publishers/contosoGroup/artifactStoreReference/store1",
 * 								},
 * 								ArtifactVersion: "1.0.0",
 * 							},
 * 							ParameterValues: "{\"publisherName\":\"{configurationparameters('MyVM_Configuration').publisherName}\",\"skuGroupName\":\"{configurationparameters('MyVM_Configuration').skuGroupName}\",\"skuVersion\":\"{configurationparameters('MyVM_Configuration').skuVersion}\",\"skuOfferingLocation\":\"{configurationparameters('MyVM_Configuration').skuOfferingLocation}\",\"nfviType\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviType}\",\"nfviId\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviId}\",\"allowSoftwareUpdates\":\"{configurationparameters('MyVM_Configuration').allowSoftwareUpdates}\",\"virtualNetworkName\":\"{configurationparameters('MyVM_Configuration').vnetName}\",\"subnetName\":\"{configurationparameters('MyVM_Configuration').subnetName}\",\"subnetAddressPrefix\":\"{configurationparameters('MyVM_Configuration').subnetAddressPrefix}\",\"managedResourceGroup\":\"{configurationparameters('SNSSelf').managedResourceGroupName}\",\"adminPassword\":\"{secretparameters('MyVM_Configuration').adminPassword}\"}",
 * 							TemplateType:    hybridnetwork.TemplateTypeArmTemplate,
 * 						},
 * 						DependsOnProfile: hybridnetwork.DependsOnProfile{
 * 							InstallDependsOn: []interface{}{},
 * 						},
 * 						Name:                "MyVM",
 * 						ResourceElementType: "ArmResourceDefinition",
 * 					},
 * 				},
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersion;
 * import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersionArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignVersionPropertiesFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkServiceDesignVersion = new NetworkServiceDesignVersion("networkServiceDesignVersion", NetworkServiceDesignVersionArgs.builder()
 *             .location("eastus")
 *             .networkServiceDesignGroupName("TestNetworkServiceDesignGroupName")
 *             .networkServiceDesignVersionName("1.0.0")
 *             .properties(NetworkServiceDesignVersionPropertiesFormatArgs.builder()
 *                 .configurationGroupSchemaReferences(Map.of("MyVM_Configuration", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/publishers/contosoGroup/networkServiceDesignGroups/NSD_contoso/configurationGroupSchemas/MyVM_Configuration_Schema")))
 *                 .resourceElementTemplates(ArmResourceDefinitionResourceElementTemplateDetailsArgs.builder()
 *                     .configuration(ArmResourceDefinitionResourceElementTemplateArgs.builder()
 *                         .artifactProfile(NSDArtifactProfileArgs.builder()
 *                             .artifactName("MyVMArmTemplate")
 *                             .artifactStoreReference(ReferencedResourceArgs.builder()
 *                                 .id("/subscriptions/subid/providers/Microsoft.HybridNetwork/publishers/contosoGroup/artifactStoreReference/store1")
 *                                 .build())
 *                             .artifactVersion("1.0.0")
 *                             .build())
 *                         .parameterValues("{\"publisherName\":\"{configurationparameters('MyVM_Configuration').publisherName}\",\"skuGroupName\":\"{configurationparameters('MyVM_Configuration').skuGroupName}\",\"skuVersion\":\"{configurationparameters('MyVM_Configuration').skuVersion}\",\"skuOfferingLocation\":\"{configurationparameters('MyVM_Configuration').skuOfferingLocation}\",\"nfviType\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviType}\",\"nfviId\":\"{nfvis().nfvisFromSitePerNfviType.AzureCore.nfviAlias1.nfviId}\",\"allowSoftwareUpdates\":\"{configurationparameters('MyVM_Configuration').allowSoftwareUpdates}\",\"virtualNetworkName\":\"{configurationparameters('MyVM_Configuration').vnetName}\",\"subnetName\":\"{configurationparameters('MyVM_Configuration').subnetName}\",\"subnetAddressPrefix\":\"{configurationparameters('MyVM_Configuration').subnetAddressPrefix}\",\"managedResourceGroup\":\"{configurationparameters('SNSSelf').managedResourceGroupName}\",\"adminPassword\":\"{secretparameters('MyVM_Configuration').adminPassword}\"}")
 *                         .templateType("ArmTemplate")
 *                         .build())
 *                     .dependsOnProfile(DependsOnProfileArgs.builder()
 *                         .installDependsOn()
 *                         .build())
 *                     .name("MyVM")
 *                     .resourceElementType("ArmResourceDefinition")
 *                     .build())
 *                 .build())
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkServiceDesignVersion TestVersion /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/networkServiceDesignGroups/{networkServiceDesignGroupName}/networkServiceDesignVersions/{networkServiceDesignVersionName}
 * ```
 */
public class NetworkServiceDesignVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersion,
) : KotlinCustomResource(javaResource, NetworkServiceDesignVersionMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * network service design version properties.
     */
    public val properties: Output<NetworkServiceDesignVersionPropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                networkServiceDesignVersionPropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkServiceDesignVersionMapper : ResourceMapper<NetworkServiceDesignVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersion::class == javaResource::class

    override fun map(javaResource: Resource): NetworkServiceDesignVersion =
        NetworkServiceDesignVersion(
            javaResource as
                com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignVersion,
        )
}

/**
 * @see [NetworkServiceDesignVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkServiceDesignVersion].
 */
public suspend fun networkServiceDesignVersion(
    name: String,
    block: suspend NetworkServiceDesignVersionResourceBuilder.() -> Unit,
):
    NetworkServiceDesignVersion {
    val builder = NetworkServiceDesignVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkServiceDesignVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkServiceDesignVersion(name: String): NetworkServiceDesignVersion {
    val builder = NetworkServiceDesignVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
