@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SitePropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SitePropertiesFormatResponse.Companion.toKotlin as sitePropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Site].
 */
@PulumiTagMarker
public class SiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SiteArgs = SiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SiteArgsBuilder.() -> Unit) {
        val builder = SiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Site {
        val builtJavaResource = com.pulumi.azurenative.hybridnetwork.Site(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Site(builtJavaResource)
    }
}

/**
 * Site resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create network site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var site = new AzureNative.HybridNetwork.Site("site", new()
 *     {
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.SitePropertiesFormatArgs
 *         {
 *             Nfvis =
 *             {
 *                 new AzureNative.HybridNetwork.Inputs.AzureCoreNFVIDetailsArgs
 *                 {
 *                     Location = "westUs2",
 *                     Name = "nfvi1",
 *                     NfviType = "AzureCore",
 *                 },
 *                 new AzureNative.HybridNetwork.Inputs.AzureArcK8sClusterNFVIDetailsArgs
 *                 {
 *                     CustomLocationReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation1",
 *                     },
 *                     Name = "nfvi2",
 *                     NfviType = "AzureArcKubernetes",
 *                 },
 *                 new AzureNative.HybridNetwork.Inputs.AzureOperatorNexusClusterNFVIDetailsArgs
 *                 {
 *                     CustomLocationReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation2",
 *                     },
 *                     Name = "nfvi3",
 *                     NfviType = "AzureOperatorNexus",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteName = "testSite",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewSite(ctx, "site", &hybridnetwork.SiteArgs{
 * 			Location: pulumi.String("westUs2"),
 * 			Properties: &hybridnetwork.SitePropertiesFormatArgs{
 * 				Nfvis: pulumi.Array{
 * 					hybridnetwork.AzureCoreNFVIDetails{
 * 						Location: "westUs2",
 * 						Name:     "nfvi1",
 * 						NfviType: "AzureCore",
 * 					},
 * 					hybridnetwork.AzureArcK8sClusterNFVIDetails{
 * 						CustomLocationReference: hybridnetwork.ReferencedResource{
 * 							Id: "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation1",
 * 						},
 * 						Name:     "nfvi2",
 * 						NfviType: "AzureArcKubernetes",
 * 					},
 * 					hybridnetwork.AzureOperatorNexusClusterNFVIDetails{
 * 						CustomLocationReference: hybridnetwork.ReferencedResource{
 * 							Id: "/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation2",
 * 						},
 * 						Name:     "nfvi3",
 * 						NfviType: "AzureOperatorNexus",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SiteName:          pulumi.String("testSite"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.Site;
 * import com.pulumi.azurenative.hybridnetwork.SiteArgs;
 * import com.pulumi.azurenative.hybridnetwork.inputs.SitePropertiesFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var site = new Site("site", SiteArgs.builder()
 *             .location("westUs2")
 *             .properties(SitePropertiesFormatArgs.builder()
 *                 .nfvis(
 *                     AzureCoreNFVIDetailsArgs.builder()
 *                         .location("westUs2")
 *                         .name("nfvi1")
 *                         .nfviType("AzureCore")
 *                         .build(),
 *                     AzureArcK8sClusterNFVIDetailsArgs.builder()
 *                         .customLocationReference(ReferencedResourceArgs.builder()
 *                             .id("/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation1")
 *                             .build())
 *                         .name("nfvi2")
 *                         .nfviType("AzureArcKubernetes")
 *                         .build(),
 *                     AzureOperatorNexusClusterNFVIDetailsArgs.builder()
 *                         .customLocationReference(ReferencedResourceArgs.builder()
 *                             .id("/subscriptions/subid/resourceGroups/testResourceGroup/providers/Microsoft.ExtendedLocation/customLocations/testCustomLocation2")
 *                             .build())
 *                         .name("nfvi3")
 *                         .nfviType("AzureOperatorNexus")
 *                         .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .siteName("testSite")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:Site testSite /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/sites/{siteName}
 * ```
 */
public class Site internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.Site,
) : KotlinCustomResource(javaResource, SiteMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Site properties.
     */
    public val properties: Output<SitePropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sitePropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SiteMapper : ResourceMapper<Site> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.Site::class == javaResource::class

    override fun map(javaResource: Resource): Site = Site(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.Site,
    )
}

/**
 * @see [Site].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Site].
 */
public suspend fun site(name: String, block: suspend SiteResourceBuilder.() -> Unit): Site {
    val builder = SiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Site].
 * @param name The _unique_ name of the resulting resource.
 */
public fun site(name: String): Site {
    val builder = SiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
