@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesNetworkFunctionTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure Arc kubernetes network function template.
 * @property networkFunctionApplications Network function applications.
 * @property nfviType The network function type.
 * Expected value is 'AzureArcKubernetes'.
 */
public data class AzureArcKubernetesNetworkFunctionTemplateArgs(
    public val networkFunctionApplications: Output<List<AzureArcKubernetesHelmApplicationArgs>>? =
        null,
    public val nfviType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesNetworkFunctionTemplateArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesNetworkFunctionTemplateArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesNetworkFunctionTemplateArgs.builder()
            .networkFunctionApplications(
                networkFunctionApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nfviType(nfviType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureArcKubernetesNetworkFunctionTemplateArgs].
 */
@PulumiTagMarker
public class AzureArcKubernetesNetworkFunctionTemplateArgsBuilder internal constructor() {
    private var networkFunctionApplications: Output<List<AzureArcKubernetesHelmApplicationArgs>>? =
        null

    private var nfviType: Output<String>? = null

    /**
     * @param value Network function applications.
     */
    @JvmName("qxrkrjyquajunmmd")
    public suspend
    fun networkFunctionApplications(`value`: Output<List<AzureArcKubernetesHelmApplicationArgs>>) {
        this.networkFunctionApplications = value
    }

    @JvmName("wbmrigycjqdnlatf")
    public suspend fun networkFunctionApplications(
        vararg
        values: Output<AzureArcKubernetesHelmApplicationArgs>,
    ) {
        this.networkFunctionApplications = Output.all(values.asList())
    }

    /**
     * @param values Network function applications.
     */
    @JvmName("deatrvxqmkixdygw")
    public suspend
    fun networkFunctionApplications(values: List<Output<AzureArcKubernetesHelmApplicationArgs>>) {
        this.networkFunctionApplications = Output.all(values)
    }

    /**
     * @param value The network function type.
     * Expected value is 'AzureArcKubernetes'.
     */
    @JvmName("utctbifxpadjygrv")
    public suspend fun nfviType(`value`: Output<String>) {
        this.nfviType = value
    }

    /**
     * @param value Network function applications.
     */
    @JvmName("rxpfsdwdevhypdhr")
    public suspend
    fun networkFunctionApplications(`value`: List<AzureArcKubernetesHelmApplicationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionApplications = mapped
    }

    /**
     * @param argument Network function applications.
     */
    @JvmName("lamwlixvcwjitoxc")
    public suspend
    fun networkFunctionApplications(argument: List<suspend AzureArcKubernetesHelmApplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureArcKubernetesHelmApplicationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkFunctionApplications = mapped
    }

    /**
     * @param argument Network function applications.
     */
    @JvmName("coabnmmrumyooxtm")
    public suspend fun networkFunctionApplications(
        vararg
        argument: suspend AzureArcKubernetesHelmApplicationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureArcKubernetesHelmApplicationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkFunctionApplications = mapped
    }

    /**
     * @param argument Network function applications.
     */
    @JvmName("marqhbnbggtnaxgb")
    public suspend
    fun networkFunctionApplications(argument: suspend AzureArcKubernetesHelmApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureArcKubernetesHelmApplicationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkFunctionApplications = mapped
    }

    /**
     * @param values Network function applications.
     */
    @JvmName("nxfjllcteujdotre")
    public suspend fun networkFunctionApplications(
        vararg
        values: AzureArcKubernetesHelmApplicationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionApplications = mapped
    }

    /**
     * @param value The network function type.
     * Expected value is 'AzureArcKubernetes'.
     */
    @JvmName("ndrqxokoexrhpwkq")
    public suspend fun nfviType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfviType = mapped
    }

    internal fun build(): AzureArcKubernetesNetworkFunctionTemplateArgs =
        AzureArcKubernetesNetworkFunctionTemplateArgs(
            networkFunctionApplications = networkFunctionApplications,
            nfviType = nfviType ?: throw PulumiNullFieldException("nfviType"),
        )
}
