@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Operator Distributed Services network function Template application definition.
 * @property artifactProfile Azure Operator Distributed Services Template artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'ArmTemplate'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs(
    public val artifactProfile: Output<AzureOperatorNexusArmTemplateArtifactProfileArgs>? = null,
    public val artifactType: Output<String>,
    public val dependsOnProfile: Output<DependsOnProfileArgs>? = null,
    public val deployParametersMappingRuleProfile:
    Output<AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs.builder()
            .artifactProfile(artifactProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .artifactType(artifactType.applyValue({ args0 -> args0 }))
            .dependsOnProfile(dependsOnProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deployParametersMappingRuleProfile(
                deployParametersMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs].
 */
@PulumiTagMarker
public class AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgsBuilder internal
constructor() {
    private var artifactProfile: Output<AzureOperatorNexusArmTemplateArtifactProfileArgs>? = null

    private var artifactType: Output<String>? = null

    private var dependsOnProfile: Output<DependsOnProfileArgs>? = null

    private var deployParametersMappingRuleProfile:
        Output<AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Azure Operator Distributed Services Template artifact profile.
     */
    @JvmName("oiuearaaggsehdlj")
    public suspend
    fun artifactProfile(`value`: Output<AzureOperatorNexusArmTemplateArtifactProfileArgs>) {
        this.artifactProfile = value
    }

    /**
     * @param value The artifact type.
     * Expected value is 'ArmTemplate'.
     */
    @JvmName("ehkasbobwrxjsutg")
    public suspend fun artifactType(`value`: Output<String>) {
        this.artifactType = value
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("fjothlcrmbwtqqip")
    public suspend fun dependsOnProfile(`value`: Output<DependsOnProfileArgs>) {
        this.dependsOnProfile = value
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("pfluwaxaklelnuqb")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: Output<AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs>) {
        this.deployParametersMappingRuleProfile = value
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("lyqlnrltihmjdnxo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure Operator Distributed Services Template artifact profile.
     */
    @JvmName("pajcgulsbvyltxef")
    public suspend fun artifactProfile(`value`: AzureOperatorNexusArmTemplateArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactProfile = mapped
    }

    /**
     * @param argument Azure Operator Distributed Services Template artifact profile.
     */
    @JvmName("sgtipjfluasfkwux")
    public suspend
    fun artifactProfile(argument: suspend AzureOperatorNexusArmTemplateArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureOperatorNexusArmTemplateArtifactProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.artifactProfile = mapped
    }

    /**
     * @param value The artifact type.
     * Expected value is 'ArmTemplate'.
     */
    @JvmName("umfedssfppbaalss")
    public suspend fun artifactType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("gqxgxndlxeupbsqm")
    public suspend fun dependsOnProfile(`value`: DependsOnProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnProfile = mapped
    }

    /**
     * @param argument Depends on profile definition.
     */
    @JvmName("dolgolffgaanfamd")
    public suspend fun dependsOnProfile(argument: suspend DependsOnProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DependsOnProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependsOnProfile = mapped
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("tiseebuyujaaqxgh")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param argument Deploy mapping rule profile.
     */
    @JvmName("bwarmopjgskyjlgs")
    public suspend
    fun deployParametersMappingRuleProfile(argument: suspend AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped =
            AzureOperatorNexusArmTemplateDeployMappingRuleProfileArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("kddgnvjxqaiewbyp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs =
        AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs(
            artifactProfile = artifactProfile,
            artifactType = artifactType ?: throw PulumiNullFieldException("artifactType"),
            dependsOnProfile = dependsOnProfile,
            deployParametersMappingRuleProfile = deployParametersMappingRuleProfile,
            name = name,
        )
}
