@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionImageApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Operator Distributed Services network function image application definition.
 * @property artifactProfile Azure Operator Distributed Services image artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'ImageFile'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureOperatorNexusNetworkFunctionImageApplicationArgs(
    public val artifactProfile: Output<AzureOperatorNexusImageArtifactProfileArgs>? = null,
    public val artifactType: Output<String>,
    public val dependsOnProfile: Output<DependsOnProfileArgs>? = null,
    public val deployParametersMappingRuleProfile:
    Output<AzureOperatorNexusImageDeployMappingRuleProfileArgs>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionImageApplicationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionImageApplicationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionImageApplicationArgs.builder()
            .artifactProfile(artifactProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .artifactType(artifactType.applyValue({ args0 -> args0 }))
            .dependsOnProfile(dependsOnProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deployParametersMappingRuleProfile(
                deployParametersMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureOperatorNexusNetworkFunctionImageApplicationArgs].
 */
@PulumiTagMarker
public class AzureOperatorNexusNetworkFunctionImageApplicationArgsBuilder internal constructor() {
    private var artifactProfile: Output<AzureOperatorNexusImageArtifactProfileArgs>? = null

    private var artifactType: Output<String>? = null

    private var dependsOnProfile: Output<DependsOnProfileArgs>? = null

    private var deployParametersMappingRuleProfile:
        Output<AzureOperatorNexusImageDeployMappingRuleProfileArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Azure Operator Distributed Services image artifact profile.
     */
    @JvmName("lifyrjorburdbcan")
    public suspend fun artifactProfile(`value`: Output<AzureOperatorNexusImageArtifactProfileArgs>) {
        this.artifactProfile = value
    }

    /**
     * @param value The artifact type.
     * Expected value is 'ImageFile'.
     */
    @JvmName("alprqxtxmbabgqpr")
    public suspend fun artifactType(`value`: Output<String>) {
        this.artifactType = value
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("dxnufaxadpyvwrxb")
    public suspend fun dependsOnProfile(`value`: Output<DependsOnProfileArgs>) {
        this.dependsOnProfile = value
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("bnmmnixomqbvpiuj")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: Output<AzureOperatorNexusImageDeployMappingRuleProfileArgs>) {
        this.deployParametersMappingRuleProfile = value
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("qmimqonenuhnyucc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure Operator Distributed Services image artifact profile.
     */
    @JvmName("pcaefllckbteurnd")
    public suspend fun artifactProfile(`value`: AzureOperatorNexusImageArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactProfile = mapped
    }

    /**
     * @param argument Azure Operator Distributed Services image artifact profile.
     */
    @JvmName("lohvaojliywmgvij")
    public suspend
    fun artifactProfile(argument: suspend AzureOperatorNexusImageArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureOperatorNexusImageArtifactProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.artifactProfile = mapped
    }

    /**
     * @param value The artifact type.
     * Expected value is 'ImageFile'.
     */
    @JvmName("sqqqtxwkwqsnndpo")
    public suspend fun artifactType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("ceaupjtveabmrrmx")
    public suspend fun dependsOnProfile(`value`: DependsOnProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnProfile = mapped
    }

    /**
     * @param argument Depends on profile definition.
     */
    @JvmName("ynjseocomjkgyadi")
    public suspend fun dependsOnProfile(argument: suspend DependsOnProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DependsOnProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependsOnProfile = mapped
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("eakbbnkqrtleahdr")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: AzureOperatorNexusImageDeployMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param argument Deploy mapping rule profile.
     */
    @JvmName("jsbqisjomiwnkrwq")
    public suspend
    fun deployParametersMappingRuleProfile(argument: suspend AzureOperatorNexusImageDeployMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureOperatorNexusImageDeployMappingRuleProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("eamimhsltqrsigsr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureOperatorNexusNetworkFunctionImageApplicationArgs =
        AzureOperatorNexusNetworkFunctionImageApplicationArgs(
            artifactProfile = artifactProfile,
            artifactType = artifactType ?: throw PulumiNullFieldException("artifactType"),
            dependsOnProfile = dependsOnProfile,
            deployParametersMappingRuleProfile = deployParametersMappingRuleProfile,
            name = name,
        )
}
