@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionTemplateArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure Operator Distributed Services network function template.
 * @property networkFunctionApplications Network function applications.
 * @property nfviType The network function type.
 * Expected value is 'AzureOperatorNexus'.
 */
public data class AzureOperatorNexusNetworkFunctionTemplateArgs(
    public val networkFunctionApplications:
    Output<List<Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs, AzureOperatorNexusNetworkFunctionImageApplicationArgs>>>? =
        null,
    public val nfviType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionTemplateArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionTemplateArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusNetworkFunctionTemplateArgs.builder()
            .networkFunctionApplications(
                networkFunctionApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .nfviType(nfviType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureOperatorNexusNetworkFunctionTemplateArgs].
 */
@PulumiTagMarker
public class AzureOperatorNexusNetworkFunctionTemplateArgsBuilder internal constructor() {
    private var networkFunctionApplications:
        Output<List<Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs, AzureOperatorNexusNetworkFunctionImageApplicationArgs>>>? =
        null

    private var nfviType: Output<String>? = null

    /**
     * @param value Network function applications.
     */
    @JvmName("gxkqeviwqlymrjkv")
    public suspend
    fun networkFunctionApplications(`value`: Output<List<Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs, AzureOperatorNexusNetworkFunctionImageApplicationArgs>>>) {
        this.networkFunctionApplications = value
    }

    @JvmName("rpjijpdkcacrkccx")
    public suspend fun networkFunctionApplications(
        vararg
        values: Output<Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs, AzureOperatorNexusNetworkFunctionImageApplicationArgs>>,
    ) {
        this.networkFunctionApplications = Output.all(values.asList())
    }

    /**
     * @param values Network function applications.
     */
    @JvmName("icqwtbanrejswpdl")
    public suspend
    fun networkFunctionApplications(values: List<Output<Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs, AzureOperatorNexusNetworkFunctionImageApplicationArgs>>>) {
        this.networkFunctionApplications = Output.all(values)
    }

    /**
     * @param value The network function type.
     * Expected value is 'AzureOperatorNexus'.
     */
    @JvmName("pxsswmbpkcnhwuob")
    public suspend fun nfviType(`value`: Output<String>) {
        this.nfviType = value
    }

    /**
     * @param value Network function applications.
     */
    @JvmName("bfugytbscmltytmm")
    public suspend
    fun networkFunctionApplications(`value`: List<Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs, AzureOperatorNexusNetworkFunctionImageApplicationArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionApplications = mapped
    }

    /**
     * @param values Network function applications.
     */
    @JvmName("ullbyweeqtevkgng")
    public suspend fun networkFunctionApplications(
        vararg
        values: Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationArgs, AzureOperatorNexusNetworkFunctionImageApplicationArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionApplications = mapped
    }

    /**
     * @param value The network function type.
     * Expected value is 'AzureOperatorNexus'.
     */
    @JvmName("jiqvkwbloxifcofh")
    public suspend fun nfviType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfviType = mapped
    }

    internal fun build(): AzureOperatorNexusNetworkFunctionTemplateArgs =
        AzureOperatorNexusNetworkFunctionTemplateArgs(
            networkFunctionApplications = networkFunctionApplications,
            nfviType = nfviType ?: throw PulumiNullFieldException("nfviType"),
        )
}
