@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactStorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property artifactStoreName The name of the artifact store.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetArtifactStorePlainArgs(
    public val artifactStoreName: String,
    public val publisherName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactStorePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactStorePlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetArtifactStorePlainArgs.builder()
            .artifactStoreName(artifactStoreName.let({ args0 -> args0 }))
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetArtifactStorePlainArgs].
 */
@PulumiTagMarker
public class GetArtifactStorePlainArgsBuilder internal constructor() {
    private var artifactStoreName: String? = null

    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the artifact store.
     */
    @JvmName("mxgtctwrixqihkio")
    public suspend fun artifactStoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.artifactStoreName = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("pjxrismjnhendjem")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tacjgeyoavwuwqlp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetArtifactStorePlainArgs = GetArtifactStorePlainArgs(
        artifactStoreName = artifactStoreName ?: throw PulumiNullFieldException("artifactStoreName"),
        publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
