@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetVendorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vendorName The name of the vendor.
 */
public data class GetVendorPlainArgs(
    public val vendorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetVendorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.GetVendorPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetVendorPlainArgs.builder()
            .vendorName(vendorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVendorPlainArgs].
 */
@PulumiTagMarker
public class GetVendorPlainArgsBuilder internal constructor() {
    private var vendorName: String? = null

    /**
     * @param value The name of the vendor.
     */
    @JvmName("aumgvfgneumwdagg")
    public suspend fun vendorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vendorName = mapped
    }

    internal fun build(): GetVendorPlainArgs = GetVendorPlainArgs(
        vendorName = vendorName ?: throw PulumiNullFieldException("vendorName"),
    )
}
